<?php

/**
 *
 * @see XenForo_Model_User
 */
class Waindigo_UpgradeCoupons_Extend_XenForo_Model_User extends XFCP_Waindigo_UpgradeCoupons_Extend_XenForo_Model_User
{

    /**
     * @see XenForo_Model_User::getFullUserById()
     */
    public function getFullUserById($userId, array $fetchOptions = array())
    {
        $user = parent::getFullUserById($userId, $fetchOptions);

        if (!XenForo_Visitor::getUserId() && !empty($user['coupon_id'])) {
            $upgradeModel = $this->_getUpgradeModel();
            Waindigo_UpgradeCoupons_Extend_XenForo_Model_UserUpgrade::$couponId = $user['coupon_id'];
        }
        return $user;
    } /* END getFullUserById */

    /**
     * Fetches a list of usernames from a set of user ids
     */
    public function getNamesByIds(array $userIds)
    {
        if (empty($userIds)) {
            return false;
        }
        $data = $this->fetchAllKeyed('
            SELECT user.username, user.user_id
            FROM xf_user AS user
            WHERE user.user_id IN (' . $this->_getDb()->quote($userIds) . ')'
            , 'user_id');
        $usernames = array();
        foreach ($data as $key => $item) {
            $usernames[$key] = $item['username'];
        }
        return $usernames;
    } /* END getNamesByIds */

    /**
     *
     * @return XenForo_Model_UserUpgrade
     */
    protected function _getUpgradeModel()
    {
        return $this->getModelFromCache('XenForo_Model_UserUpgrade');
    } /* END _getUpgradeModel */
}