<?php

/**
 *
 * @see XenForo_Model_UserUpgrade
 */
class Waindigo_UpgradeCoupons_Extend_XenForo_Model_UserUpgrade extends XFCP_Waindigo_UpgradeCoupons_Extend_XenForo_Model_UserUpgrade
{

    public static $couponId;

    /**
     * Gets the specified upgrade, alters the amount if required by Upgrade
     * Coupons
     *
     * @see XenForo_Model_UserUpgrade::getUserUpgradeById()
     *
     * @param integer $id
     * @return array false
     */
    public function getUserUpgradeById($id)
    {
        $upgrade = parent::getUserUpgradeById($id);
        
        if (!empty(self::$couponId)) {
            $couponModel = $this->_getCouponModel();
            $coupon = $couponModel->getCouponById(self::$couponId);
            if (!empty($coupon)) {
                
                if ($this->userUpgradesCheck()) {
                    if ($upgrade['tiered_upgrade']) {
                        Waindigo_UserUpgrades_Extend_XenForo_Model_UserUpgrade::$userId = 0;
                        return $upgrade;
                    }
                }
                if ($couponModel->checkCouponWithUpgrade($coupon, $upgrade)) {
                    if (isset($upgrade['coupon_applied'])) {
                        return $upgrade;
                    }
                    return $couponModel->applyCouponToUpgrade($upgrade, $coupon);
                } else {
                    Waindigo_UpgradeCoupons_Extend_XenForo_Model_UserUpgrade::$couponId = 0;
                    return $upgrade;
                }
            }
        } else {
            return $upgrade;
        }
    } /* END getUserUpgradeById */

    /**
     * Gets a list of upgrades that are applicable to the specified user.
     *
     * @see XenForo_Model_UserUpgrade::getUserUpgradesForPurchaseList()
     */
    public function getUserUpgradesForPurchaseList(array $viewingUser = null)
    {
        $purchaseList = parent::getUserUpgradesForPurchaseList($viewingUser);
        $this->standardizeViewingUserReference($viewingUser);
        
        if (!empty($viewingUser['coupon_id'])) {
            $couponModel = $this->_getCouponModel();
            $coupon = $couponModel->getCouponById($viewingUser['coupon_id']);
            if (!empty($coupon['upgrade_ids'])) {
                $allowedUpgradeIds = explode(',', $coupon['upgrade_ids']);
            }
        }
        
        if (!empty($purchaseList['available']) && !empty($coupon)) {
            $freeUpgrades = array();
            if (isset($allowedUpgradeIds)) {
                foreach ($purchaseList['available'] as $upgradeId => $upgrade) {
                    if (in_array($upgrade['user_upgrade_id'], $allowedUpgradeIds)) {
                        if ($couponModel->checkCouponWithUpgrade($coupon, $upgrade)) {
                            $purchaseList['available'][$upgradeId] = $couponModel->applyCouponToUpgrade($upgrade, 
                                $coupon);
                            if ($purchaseList['available'][$upgradeId]['cost_amount'] <= 0) {
                                unset($purchaseList['available'][$upgradeId]);
                                if (!$upgrade['recurring']) {
                                    $freeUpgrades[] = $upgrade;
                                }
                            }
                        }
                    }
                }
            } else {
                foreach ($purchaseList['available'] as $upgradeId => $upgrade) {
                    if ($couponModel->checkCouponWithUpgrade($coupon, $upgrade)) {
                        $purchaseList['available'][$upgradeId] = $couponModel->applyCouponToUpgrade($upgrade, $coupon);
                        if ($purchaseList['available'][$upgradeId]['cost_amount'] <= 0) {
                            unset($purchaseList['available'][$upgradeId]);
                            if (!$upgrade['recurring']) {
                                $freeUpgrades[] = $upgrade;
                            }
                        }
                    }
                }
            }
            if (!empty($freeUpgrades)) {
                $purchaseList['freeUpgrades'] = $freeUpgrades;
            }
        }
        
        $giftUpgrades = array();
        if (!empty($purchaseList['available'])) {
            $this->prepareGiftPurchaseList($purchaseList['available'], $giftUpgrades);
        }
        if (!empty($purchaseList['purchased'])) {
            $this->prepareGiftPurchaseList($purchaseList['purchased'], $giftUpgrades);
        }
        if (!empty($purchaseList['freeUpgrades'])) {
            $this->prepareGiftPurchaseList($purchaseList['freeUpgrades'], $giftUpgrades);
        }
        if (!empty($giftUpgrades)) {
            $purchaseList['giftUpgrades'] = $giftUpgrades;
        }
        return $purchaseList;
    } /* END getUserUpgradesForPurchaseList */

    public function prepareGiftPurchaseList(array $upgrades, array &$giftUpgrades)
    {
        if ($this->userUpgradesCheck()) {
            if (XenForo_Application::get('options')->waindigo_upgradeCoupons_overrideHiddenWhenGift) {
                foreach ($upgrades as $upgrade) {
                    if ($upgrade['allow_gift_purchase'] && $upgrade['allow_coupons'] &&
                         (!$upgrade['length_amount_post_trial'] || !$upgrade['length_unit_post_trial']) &&
                         !$upgrade['tiered_upgrade']) {
                        $giftUpgrades[$upgrade['user_upgrade_id']] = $upgrade;
                    }
                }
            } else {
                foreach ($upgrades as $upgrade) {
                    if ($upgrade['allow_gift_purchase'] && $upgrade['allow_coupons'] &&
                         (!$upgrade['length_amount_post_trial'] || !$upgrade['length_unit_post_trial']) &&
                         !$upgrade['tiered_upgrade'] && !$upgrade['hidden']) {
                        $giftUpgrades[$upgrade['user_upgrade_id']] = $upgrade;
                    }
                }
            }
        } else {
            foreach ($upgrades as $upgrade) {
                if ($upgrade['allow_gift_purchase'] && $upgrade['allow_coupons']) {
                    $giftUpgrades[$upgrade['user_upgrade_id']] = $upgrade;
                }
            }
        }
        //removes recurring upgrades - may edit this later
        if (!empty($giftUpgrades) /*&& !XenForo_Application::get('options')->waindigo_upgradeCoupons_allowRecurring */) {
            foreach ($giftUpgrades as $upgrade) {
                if ($upgrade['recurring']) {
                    unset($giftUpgrades[$upgrade['user_upgrade_id']]);
                }
            }
        }
    } /* END prepareGiftPurchaseList */

    /**
     *
     * @see XenForo_Model_UserUpgrade::prepareUserUpgrade()
     */
    public function prepareUserUpgrade(array $upgrade)
    {
        $upgrade = parent::prepareUserUpgrade($upgrade);
        
        return $upgrade;
    } /* END prepareUserUpgrade */

    /**
     *
     * @see XenForo_Model_UserUpgrade::upgradeUser()
     */
    public function upgradeUser($userId, array $upgrade, $allowInsertUnpurchasable = false, $endDate = null)
    {
        if (isset($upgrade['gift_purchase_user_ids'])) {
            $giftUserIds = explode(',', $upgrade['gift_purchase_user_ids']);
            if (in_array($userId, $giftUserIds)) {
                $this->giftUpgrade($userId, $upgrade, $allowInsertUnpurchasable, $endDate);
                return false;
            }
        }
        
        if ($this->getActiveUserUpgradeRecord($userId, $upgrade['user_upgrade_id'])) {
            return parent::upgradeUser($userId, $upgrade, $allowInsertUnpurchasable, $endDate);
        }
        
        if (!empty(self::$couponId)) {
            $coupon = $this->_getCouponModel()->getCouponById(self::$couponId);
            if (!empty($coupon) && $this->_getCouponModel()->checkCouponWithUpgrade($coupon, $upgrade, $userId)) {
                if (!$coupon['multiple_use'] || ($coupon['multiple_use'] && $coupon['re_entry_required']) ||
                     $coupon['single_use']) {
                    /* @var $userDw XenForo_DataWriter_User */
                    $userDw = XenForo_DataWriter::create('XenForo_DataWriter_User');
                    $userDw->setExistingData($userId);
                    $userDw->set('coupon_id', 0);
                    $userDw->preSave();
                    if ($dwErrors = $userDw->getErrors()) {
                        return $this->responseError($dwErrors);
                    }
                    $userDw->save();
                }
                if (!empty($coupon['user_ids'])) {
                    $couponUserIds = explode(',', $coupon['user_ids']);
                    if (!in_array($userId, $couponUserIds)) {
                        $coupon['user_ids'] = $coupon['user_ids'] . ',' . $userId;
                    }
                } else {
                    $coupon['user_ids'] = $userId;
                }
                /* @var $couponDw Waindigo_UpgradeCoupons_DataWriter_UpgradeCoupons */
                $couponDw = XenForo_DataWriter::create('Waindigo_UpgradeCoupons_DataWriter_UpgradeCoupons');
                $couponDw->setExistingData($coupon['coupon_id']);
                $couponDw->set('user_ids', $coupon['user_ids']);
                if ($coupon['single_use']) {
                    $couponDw->set('is_active', 0);
                }
                if ($coupon['is_gift']) {
                    $couponDw->set('gift_status', 'redeemed');
                    $extraData = array_merge(unserialize($coupon['extra_data']), 
                        array(
                            'redeemer_user_id' => $userId,
                            'purchase_date' => XenForo_Application::$time
                        ));
                    $couponDw->set('extra_data', $extraData);
                }
                $couponDw->save();
                $upgradeRecordId = parent::upgradeUser($userId, $upgrade, $allowInsertUnpurchasable, $endDate);
                
                if ($upgradeRecordId) {
                    $extra = array(
                        'cost_amount' => $upgrade['cost_amount'],
                        'cost_currency' => $upgrade['cost_currency'],
                        'length_amount' => $upgrade['length_amount'],
                        'length_unit' => $upgrade['length_unit'],
                        'coupon_id' => $coupon['coupon_id'],
                        'coupon_title' => $coupon['title'],
                        'coupon_amount' => $coupon['amount'],
                        'coupon_type' => $coupon['coupon_type']
                    );
                    $this->_getDb()->update('xf_user_upgrade_active', 
                        array(
                            'extra' => serialize($extra)
                        ), 
                        'user_upgrade_record_id = ' . $this->_getDb()
                            ->quote($upgradeRecordId));
                }
                if ($upgrade['gift_coupon_id']) {
                    $this->_getCouponModel()->sendUserCoupon($upgrade['gift_coupon_id'], $userId);
                }
                return $upgradeRecordId;
            }
        }
        
        if ($upgrade['gift_coupon_id']) {
            $this->_getCouponModel()->sendUserCoupon($upgrade['gift_coupon_id'], $userId);
        }
        
        return parent::upgradeUser($userId, $upgrade, $allowInsertUnpurchasable, $endDate);
    } /* END upgradeUser */

    public function giftUpgrade($userId, array $upgrade, $allowInsertUnpurchasable = false, $endDate = null)
    {
        /* @var $couponModel Waindigo_UpgradeCoupons_Model_UpgradeCoupons */
        $couponModel = $this->_getCouponModel();
        
        $giftCoupon = $couponModel->getGiftCoupon($upgrade['user_upgrade_id']);
        $couponModel->sendUserCoupon($upgrade['gift_coupon_id'], $userId);
        $this->updateUpgradeForGift($upgrade, $userId, 'removeUser');
        $couponModel->updateGiftCoupon($upgrade, $userId, 'activated');
        if (!empty(self::$couponId)) {
            $coupon = $couponModel->getCouponById(self::$couponId);
            if (!empty($coupon) && $couponModel->checkCouponWithUpgrade($coupon, $upgrade)) {
                if (!$coupon['multiple_use'] || ($coupon['multiple_use'] && $coupon['re_entry_required']) ||
                     $coupon['single_use']) {
                    /* @var $userDw XenForo_DataWriter_User */
                    $userDw = XenForo_DataWriter::create('XenForo_DataWriter_User');
                    $userDw->setExistingData($userId);
                    $userDw->set('coupon_id', 0);
                    $userDw->preSave();
                    if ($dwErrors = $userDw->getErrors()) {
                        return $this->responseError($dwErrors);
                    }
                    $userDw->save();
                }
                if (!empty($coupon['user_ids'])) {
                    $couponUserIds = explode(',', $coupon['user_ids']);
                    if (!in_array($userId, $couponUserIds)) {
                        $coupon['user_ids'] = $coupon['user_ids'] . ',' . $userId;
                    }
                } else {
                    $coupon['user_ids'] = $userId;
                }
                /* @var $couponDw Waindigo_UpgradeCoupons_DataWriter_UpgradeCoupons */
                $couponDw = XenForo_DataWriter::create('Waindigo_UpgradeCoupons_DataWriter_UpgradeCoupons');
                $couponDw->setExistingData($coupon['coupon_id']);
                $couponDw->set('user_ids', $coupon['user_ids']);
                if ($coupon['single_use']) {
                    $couponDw->set('is_active', 0);
                }
                if ($coupon['is_gift']) {
                    $couponDw->set('gift_status', 'redeemed');
                    $extraData = array_merge(unserialize($coupon['extra_data']), 
                        array(
                            'redeemer_user_id' => $userId,
                            'purchase_date' => XenForo_Application::$time
                        ));
                    $couponDw->set('extra_data', $extraData);
                }
                $couponDw->save();
            }
        }
    } /* END giftUpgrade */

    /**
     * Updates the upgrade with user information for gift purchases
     *
     * @param array $upgrade
     */
    public function updateUpgradeForGift(array $upgrade, $userId = null, $updateType = 'addUser')
    {
        if (!$userId) {
            $userId = XenForo_Visitor::getUserId();
        }
        
        if ($updateType == 'addUser') {
            if (isset($upgrade['gift_purchase_user_ids'])) {
                $giftUserIds = explode(',', $upgrade['gift_purchase_user_ids']);
                if (!in_array($userId, $giftUserIds)) {
                    $giftUserIds[] = $userId;
                }
            } else {
                $giftUserIds = $userId;
            }
        } elseif ($updateType == 'removeUser') {
            if (isset($upgrade['gift_purchase_user_ids'])) {
                $giftUserIds = explode(',', $upgrade['gift_purchase_user_ids']);
                if (($key = array_search($userId, $giftUserIds)) !== false) {
                    unset($giftUserIds[$key]);
                }
            }
        }
        if (is_array($giftUserIds)) {
            $giftUserIds = implode(',', $giftUserIds);
        }
        
        /* @var $dw XenForo_DataWriter_UserUpgrade */
        $dw = XenForo_DataWriter::create('XenForo_DataWriter_UserUpgrade');
        $dw->setExistingData($upgrade['user_upgrade_id']);
        $dw->set('gift_purchase_user_ids', $giftUserIds);
        $dw->save();
    } /* END updateUpgradeForGift */

    /**
     * Adds coupon data to log if required.
     *
     * @see XenForo_Model_UserUpgrade::logProcessorCallback()
     */
    public function logProcessorCallback($userUpgradeRecordId, $processor, $transactionId, $transactionType, $message, 
        array $details, $subscriberId = '')
    {
        if (!empty(self::$couponId)) {
            $coupon = $this->_getCouponModel()->getCouponById(self::$couponId);
            $upgrade = $this->getUserUpgradeByUpgradeRecordId($userUpgradeRecordId);
            if (!empty($coupon) && !empty($upgrade)) {
                if ($this->_getCouponModel()->checkCouponWithUpgrade($coupon, $upgrade)) {
                    $details = array_merge($details, 
                        array(
                            'coupon_id' => $coupon['coupon_id'],
                            'coupon_title' => $coupon['title'],
                            'coupon_amount' => $coupon['amount'],
                            'coupon_type' => $coupon['coupon_type']
                        ));
                }
            }
        }
        return parent::logProcessorCallback($userUpgradeRecordId, $processor, $transactionId, $transactionType, 
            $message, $details, $subscriberId);
    } /* END logProcessorCallback */

    public function getUserUpgradeByUpgradeRecordId($id)
    {
        return $this->_getDb()->fetchRow(
            '
			SELECT *
			FROM xf_user_upgrade AS upgrade
            LEFT JOIN xf_user_upgrade_active AS upgrade_active ON
            (upgrade_active.user_upgrade_id = upgrade.user_upgrade_id)
			WHERE user_upgrade_record_id = ?
		', $id);
    } /* END getUserUpgradeByUpgradeRecordId */

    public function userUpgradesCheck()
    {
        if (XenForo_Application::$versionId >= 1020000) {
            $addOns = XenForo_Application::get('addOns');
            if (isset($addOns['Waindigo_UserUpgrades'])) {
                return true;
            }
        } else {
            /* @var $addOnModel XenForo_Model_AddOn */
            $addOnModel = XenForo_Model::create('XenForo_Model_AddOn');
            $addOn = $addOnModel->getAddOnById('Waindigo_UserUpgrades');
            if ($addOn && $addOn['active']) {
                return true;
            }
        }
        return false;
    } /* END userUpgradesCheck */

    /**
     *
     * @return XenForo_Model_User
     */
    protected function _getUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    } /* END _getUserModel */

    /**
     *
     * @return Waindigo_UpgradeCoupons_Model_UpgradeCoupons
     */
    protected function _getCouponModel()
    {
        return $this->getModelFromCache('Waindigo_UpgradeCoupons_Model_UpgradeCoupons');
    } /* END _getCouponModel */
}