<?php

class Waindigo_UpgradeCoupons_Install_Controller extends Waindigo_Install
{

    protected $_resourceManagerUrl = 'http://xenforo.com/community/resources/upgrade-coupons-by-waindigo.3009/';

    /**
     * @see Waindigo_Install::_getTables()
     */
    protected function _getTables()
    {
        return array(
            'xf_upgrade_coupon_waindigo' => array(
                'coupon_id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY', /* END 'coupon_id' */
                'is_active' => 'BOOLEAN NOT NULL DEFAULT 1', /* END 'is_active' */
                'title' => 'VARCHAR(255) NOT NULL', /* END 'title' */
                'amount' => 'DECIMAL(10, 2) NOT NULL DEFAULT 0', /* END 'amount' */
                'coupon_type' => 'ENUM(\'percentage\', \'flat_rate\') NOT NULL DEFAULT \'flat_rate\'', /* END 'coupon_type' */
                'coupon_key' => 'VARCHAR(255) NOT NULL', /* END 'coupon_key' */
                'user_ids' => 'VARBINARY(255) NOT NULL DEFAULT \'\'', /* END 'user_ids' */
                'upgrade_ids' => 'VARBINARY(255) NOT NULL DEFAULT \'\'', /* END 'upgrade_ids' */
                'multiple_use' => 'BOOLEAN NOT NULL DEFAULT 0', /* END 'multiple_use' */
                're_entry_required' => 'BOOLEAN NOT NULL DEFAULT 1', /* END 're_entry_required' */
                'single_use' => 'BOOLEAN NOT NULL DEFAULT 0', /* END 'single_use' */
                'initial_payment_only' => 'BOOLEAN NOT NULL DEFAULT 0', /* END 'initial_payment_only' */
                'is_gift' => 'BOOLEAN NOT NULL DEFAULT 0', /* END 'is_gift' */
                'gift_status' => 'VARCHAR(255) NOT NULL', /* END 'gift_status' */
                'extra_data' => 'mediumblob NULL COMMENT \'Serialized. Stores any extra data relevant to the coupon\'', /* END 'extra_data' */
            ), /* END 'xf_upgrade_coupon_waindigo' */
        );
    } /* END _getTables */

    /**
     * @see Waindigo_Install::_getTableChanges()
     */
    protected function _getTableChanges()
    {
        return array(
            'xf_user_upgrade' => array(
                'allow_coupons' => 'BOOLEAN NOT NULL DEFAULT 1', /* END 'allow_coupons' */
                'gift_coupon_id' => 'int(10) unsigned NOT NULL DEFAULT 0', /* 'gift_coupon_id' */
                'allow_gift_purchase' => 'BOOLEAN NOT NULL DEFAULT 0', /* 'allow_gift_purchase' */
                'gift_purchase_user_ids' => 'VARBINARY(255) NOT NULL DEFAULT \'\'', /* END 'gift_purchase_user_ids' */
            ), /* END 'xf_user_upgrade' */
            'xf_user_profile' => array(
                'coupon_id' => 'INT(10) NOT NULL DEFAULT 0', /* END 'coupon_id' */
            ), /* END 'xf_user_profile' */
        );
    } /* END _getTableChanges */
}