<?php

class Waindigo_UpgradeCoupons_Listener_LoadClass extends Waindigo_Listener_LoadClass
{

    protected function _getExtendedClasses()
    {
        return array(
            'Waindigo_UpgradeCoupons' => array(
                'controller' => array(
                    'XenForo_ControllerPublic_Account',
                    'XenForo_ControllerAdmin_UserUpgrade',
                ), /* END 'controller' */
                'datawriter' => array(
                    'XenForo_DataWriter_UserUpgrade',
                    'XenForo_DataWriter_User'
                ), /* END 'datawriter' */
                'model' => array(
                    'XenForo_Model_UserUpgrade',
                    'XenForo_Model_User'
                ), /* END 'model' */
            ), /* END 'Waindigo_UpgradeCoupons' */
        );
    } /* END _getExtendedClasses */

    public static function loadClassController($class, array &$extend)
    {
        $loadClassController = new Waindigo_UpgradeCoupons_Listener_LoadClass($class, $extend, 'controller');
        $extend = $loadClassController->run();
    } /* END loadClassController */

    public static function loadClassDataWriter($class, array &$extend)
    {
        $loadClassDataWriter = new Waindigo_UpgradeCoupons_Listener_LoadClass($class, $extend, 'datawriter');
        $extend = $loadClassDataWriter->run();
    } /* END loadClassDataWriter */

    public static function loadClassModel($class, array &$extend)
    {
        $loadClassModel = new Waindigo_UpgradeCoupons_Listener_LoadClass($class, $extend, 'model');
        $extend = $loadClassModel->run();
    } /* END loadClassModel */
}