<?php

/**
 * Upgrade coupons prefix handler
 */
class Waindigo_UpgradeCoupons_Route_PrefixAdmin_UpgradeCoupons implements XenForo_Route_Interface
{

    /**
     * Match prefix against class
     *
     * @param string $routePath
     * @param Zend_Controller_Request_Http $request
     * @param XenForo_Router $router
     * @return $router->getRouteMatch()
     */
    public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
    {
        $action = $router->resolveActionWithIntegerParam($routePath, $request, 'coupon_id');
        return $router->getRouteMatch('Waindigo_UpgradeCoupons_ControllerAdmin_UpgradeCoupons', $action, 'userUpgrades');
    } /* END match */

    /**
     * Method to build a link to the specified page/action with the provided
     * data and params.
     *
     * @see XenForo_Route_BuilderInterface
     */
    public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
    {
        return XenForo_Link::buildBasicLinkWithIntegerParam($outputPrefix, $action, $extension, $data, 'coupon_id', 'title');
    } /* END buildLink */
}