<?php

/**
 *
 * @see XenForo_ControllerPublic_Member
 */
class Waindigo_UserEditFrontEnd_Extend_XenForo_ControllerPublic_Member extends XFCP_Waindigo_UserEditFrontEnd_Extend_XenForo_ControllerPublic_Member
{

    /**
     * Member profile page
     *
     * @return XenForo_ControllerResponse_View
     */
    public function actionMember()
    {
        $response = parent::actionMember();
        
        if ($response instanceof XenForo_ControllerResponse_View) {
            $response->params['canEditFullUser'] = $this->_getUserModel()->canEditFullUser($response->params['user']);
        }
        
        return $response;
    } /* END actionMember */

    public function actionEditFull()
    {
        $userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
        
        /* @var $userModel XenForo_Model_User */
        $userModel = $this->_getUserModel();
        
        $user = $userModel->getFullUserById($userId);
        
        if (!$userModel->canEditFullUser($user)) {
            return $this->responseNoPermission();
        }
        
        /* @var $fieldModel XenForo_Model_UserField */
        $fieldModel = $this->_getFieldModel();
        $customFields = $fieldModel->prepareUserFields(
            $fieldModel->getUserFields(array(), array(
                'valueUserId' => $user['user_id']
            )), true);
        
        $options = XenForo_Application::get('options');
        
        $viewParams = array(
            'user' => $user,
            'birthday' => $this->_getUserProfileModel()->getUserBirthdayDetails($user, true),
            'canEditAvatar' => $options->waindigo_userEditFrontEnd_avatar,
            'canEditCustomTitle' => $options->waindigo_userEditFrontEnd_customTitle,
            'canEditAbout' => $options->waindigo_userEditFrontEnd_about,
            'canEditUsername' => $options->waindigo_userEditFrontEnd_username,
            'canEditEmail' => $options->waindigo_userEditFrontEnd_email,
            'canEditSignature' => $options->waindigo_userEditFrontEnd_signature,
            'canEditBirthday' => $options->waindigo_userEditFrontEnd_birthday,
            'canEditBirthdayPrivacy' => $options->waindigo_userEditFrontEnd_birthdayPrivacy,
            
            'customFieldsGrouped' => $fieldModel->groupUserFields($customFields)
        );
        
        return $this->responseView('Waindigo_UserEditFrontEnd_ViewPublic_MemberEdit', 
            'waindigo_member_edit_usereditfrontend', $viewParams);
    } /* END actionEditFull */

    /**
     * Save members profile data
     *
     * @return XenForo_ControllerResponse_Redirect
     */
    public function actionEditFullSave()
    {
        $this->_assertPostOnly();
        
        $userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
        $userFetchOptions = array(
            'join' => XenForo_Model_User::FETCH_USER_PERMISSIONS
        );
        $user = $this->getHelper('UserProfile')->getUserOrError($userId, $userFetchOptions);
        
        $visitor = XenForo_Visitor::getInstance();
        $userModel = $this->_getUserModel();
        
        if (!$userModel->canEditFullUser($visitor->toArray())) {
            return $this->responseNoPermission();
        }
        $settings = $this->_input->filter(
            array(
                // essentials
                'username' => XenForo_Input::STRING,
                'email' => XenForo_Input::STRING,
                
                // personal details
                'gender' => XenForo_Input::STRING,
                'dob_day' => XenForo_Input::UINT,
                'dob_month' => XenForo_Input::UINT,
                'dob_year' => XenForo_Input::UINT,
                'location' => XenForo_Input::STRING,
                'occupation' => XenForo_Input::STRING,
                
                // profile info
                'status' => XenForo_Input::STRING,
                'custom_title' => XenForo_Input::STRING,
                'homepage' => XenForo_Input::STRING,
                'about' => XenForo_Input::STRING,
                'signature' => XenForo_Input::STRING,
                
                // privacy
                'show_dob_date' => XenForo_Input::UINT,
                'show_dob_year' => XenForo_Input::UINT
            ));
        
        if ($settings['about'] !== '' && XenForo_Application::get('options')->waindigo_userEditFrontEnd_about) {
            $settings['about'] = XenForo_Helper_String::autoLinkBbCode($settings['about']);
        } else {
            unset($settings['about']);
        }
        
        if ($user['dob_day'] && $user['dob_month'] && $user['dob_year']) {
            // can't change dob if set
            unset($settings['dob_day'], $settings['dob_month'], $settings['dob_year']);
        }
        
        $customFields = $this->_input->filterSingle('custom_fields', XenForo_Input::ARRAY_SIMPLE);
        $customFieldsShown = $this->_input->filterSingle('custom_fields_shown', XenForo_Input::STRING, 
            array(
                'array' => true
            ));
        
        $writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
        $writer->setExistingData($user['user_id']);
        $writer->setOption(XenForo_DataWriter_User::OPTION_ADMIN_EDIT, true);
        $writer->bulkSet($settings);
        $writer->setCustomFields($customFields, $customFieldsShown);
        
        $writer->preSave();
        
        if ($dwErrors = $writer->getErrors()) {
            return $this->responseError($dwErrors);
        }
        
        $writer->save();
        
        if ($this->_noRedirect()) {
            $user = $writer->getMergedData();
            
            // send new avatar URLs if the user's gender has changed
            if (!$user['avatar_date'] && !$user['gravatar'] && $writer->isChanged('gender')) {
                return $this->responseView('XenForo_ViewPublic_Account_GenderChange', '', 
                    array(
                        'user' => $user
                    ));
            }
        }
        
        return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 
            XenForo_Link::buildPublicLink('members/member'), null, 
            array(
                'user_id' => $user['user_id']
            ));
    } /* END actionEditFullSave */

    public function actionAvatar()
    {
        $userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
        $userFetchOptions = array(
            'join' => XenForo_Model_User::FETCH_USER_PROFILE
        );
        $user = $this->getHelper('UserProfile')->getUserOrError($userId, $userFetchOptions);
        $visitor = XenForo_Visitor::getInstance();
        $userModel = $this->_getUserModel();
        
        if (!$userModel->canEditFullUser($visitor->toArray())) {
            return $this->responseNoPermission();
        }
        
        $maxWidth = XenForo_Model_Avatar::getSizeFromCode('m');
        
        $gravatarEmail = $user['gravatar'] ? $user['gravatar'] : $user['email'];
        $gravatarUrl = ($this->_request->isSecure() ? 'https://secure' : 'http://www') . '.gravatar.com/avatar/' .
             md5($gravatarEmail) . '?s=' . $maxWidth;
        
        $viewParams = array(
            'user' => $user,
            'sizeCode' => 'm',
            'maxWidth' => $maxWidth,
            'maxDimension' => ($user['avatar_width'] > $user['avatar_height'] ? 'height' : 'width'),
            'width' => $user['avatar_width'],
            'height' => $user['avatar_height'],
            'cropX' => $user['avatar_crop_x'],
            'cropY' => $user['avatar_crop_y'],
            'gravatarEmail' => $gravatarEmail,
            'gravatarUrl' => $gravatarUrl
        );
        
        return $this->responseView('Waindigo_UserEditFrontEnd_ViewPublic_Avatar', 
            'waindigo_member_avatar_usereditfrontend', $viewParams);
    } /* END actionAvatar */

    public function actionAvatarUpload()
    {
        $this->_assertPostOnly();
        
        $userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
        $userFetchOptions = array(
            'join' => XenForo_Model_User::FETCH_USER_PERMISSIONS
        );
        $user = $this->getHelper('UserProfile')->getUserOrError($userId, $userFetchOptions);
        $visitor = XenForo_Visitor::getInstance();
        $userModel = $this->_getUserModel();
        
        if (!$userModel->canEditFullUser($visitor->toArray())) {
            return $this->responseNoPermission();
        }
        
        $avatar = XenForo_Upload::getUploadedFile('avatar');
        
        /* @var $avatarModel XenForo_Model_Avatar */
        $avatarModel = $this->getModelFromCache('XenForo_Model_Avatar');
        
        $inputData = $this->_input->filter(
            array(
                'delete' => XenForo_Input::UINT,
                'avatar_crop_x' => XenForo_Input::UINT,
                'avatar_crop_y' => XenForo_Input::UINT,
                'gravatar' => XenForo_Input::STRING,
                'use_gravatar' => XenForo_Input::UINT
            ));
        
        // upload new avatar
        if ($avatar) {
            $avatarData = $avatarModel->uploadAvatar($avatar, $user['user_id'], 
                unserialize($user['global_permission_cache']));
        }         // delete avatar
else 
            if ($inputData['delete']) {
                $avatarData = $avatarModel->deleteAvatar($user['user_id']);
            }             // use Gravatar
else 
                if (XenForo_Application::get('options')->gravatarEnable && $inputData['use_gravatar']) {
                    if (!$inputData['gravatar']) {
                        $inputData['gravatar'] = $user['email'];
                    }
                    
                    if (!XenForo_Model_Avatar::gravatarExists($inputData['gravatar'], $errorText)) {
                        return $this->responseError($errorText);
                    } else {
                        $avatarData = array(
                            'gravatar' => $inputData['gravatar']
                        );
                        
                        $this->_saveMemberSettings($avatarData, $user['user_id'], $errors);
                    }
                }                 // re-crop avatar thumbnail
else 
                    if ($inputData['avatar_crop_x'] != $user['avatar_crop_x'] ||
                         $inputData['avatar_crop_y'] != $user['avatar_crop_y']) {
                        $avatarData = $avatarModel->recropAvatar($user['user_id'], $inputData['avatar_crop_x'], 
                            $inputData['avatar_crop_y']);
                    }                     // get rid of gravatar
else 
                        if ($user['gravatar'] && !$inputData['use_gravatar']) {
                            $avatarData = array(
                                'gravatar' => ''
                            );
                            
                            $this->_saveMemberSettings($avatarData, $user['user_id'], $errors);
                        }
        
        // merge new data into $user, if there is any
        if (isset($avatarData) && is_array($avatarData)) {
            foreach ($avatarData as $key => $val) {
                $user[$key] = $val;
            }
        }
        
        $message = new XenForo_Phrase('upload_completed_successfully');
        
        // return a view if noredirect has been requested and we are not deleting
        if ($this->_noRedirect()) {
            return $this->responseView('Waindigo_UserEditFrontEnd_ViewPublic_Account_AvatarUpload', 
                'waindigo_avatar_upload_usereditfrontend', 
                array(
                    'user' => $user,
                    'sizeCode' => 'm',
                    'maxWidth' => XenForo_Model_Avatar::getSizeFromCode('m'),
                    'maxDimension' => ($user['avatar_width'] > $user['avatar_height'] ? 'height' : 'width'),
                    'width' => $user['avatar_width'],
                    'height' => $user['avatar_height'],
                    'cropX' => $user['avatar_crop_x'],
                    'cropY' => $user['avatar_crop_y'],
                    'user_id' => $user['user_id'],
                    'avatar_date' => $user['avatar_date'],
                    'gravatar' => $user['gravatar'],
                    'message' => $message
                ));
        } else {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 
                XenForo_Link::buildPublicLink('members/edit-full', $user), $message);
        }
    } /* END actionAvatarUpload */

    protected function _saveMemberSettings($settings, $userId, &$errors)
    {
        $writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
        $writer->setExistingData($userId);
        $writer->bulkSet($settings);
        $writer->preSave();
        if ($dwErrors = $writer->getErrors()) {
            $errors = (is_array($errors) ? $dwErrors + $errors : $dwErrors);
            return false;
        }
        $writer->save();
        return $writer;
    } /* END _saveMemberSettings */
}