<?php

/**
 *
 * @see XenForo_Model_User
 */
class Waindigo_UserEditFrontEnd_Extend_XenForo_Model_User extends XFCP_Waindigo_UserEditFrontEnd_Extend_XenForo_Model_User
{

    /**
     * Determines if the viewing user can edit a user's full details
     * (moderator-level permission for editing)
     *
     * @param array $user
     * @param string $errorPhraseKey
     * @param array|null $viewingUser
     *
     * @return boolean
     */
    public function canEditFullUser(array $user, &$errorPhraseKey = '', array $viewingUser = null)
    {
        $this->standardizeViewingUserReference($viewingUser);
        
        if (!$viewingUser['user_id']) {
            return false;
        }
        
        $viewerIsSuperAdmin = $this->isUserSuperAdmin($viewingUser);
        if ($viewerIsSuperAdmin) {
            return true;
        }
        
        // Super admins can only be edited by super admins.
        if ($this->isUserSuperAdmin($user) && !$viewerIsSuperAdmin) {
            return false;
        }
        $options = XenForo_Application::get('options');
        // Sub-account parents can edit their children.
        if ($this->_subAccountsCheck() && $options->waindigo_userEditFrontEnd_subaccountsEdit &&
             $viewingUser['user_id'] == $user['subaccount_parent_user_id']) {
            return true;
        }
        
        if ($viewingUser['is_admin']) {
            $adminPermissions = XenForo_Model::create('XenForo_Model_Admin')->getAdminPermissionCacheForUser(
                $viewingUser['user_id']);
            if ($adminPermissions && !empty($adminPermissions['user'])) {
                return true;
            }
        }
        
        if (!$options->waindigo_userEditFrontEnd_overrideModBlock) {
            if ($user['is_admin'] || $user['is_moderator'] || $user['is_staff']) {
                // moderators can't edit admins/mods/staff
                return false;
            }
        }
        if (!$this->isMemberOfUserGroup($user, array_keys($options->waindigo_userEditFrontEnd_allowedUserGroups), true)) {
            return false;
        }
        return XenForo_Permission::hasPermission($viewingUser['permissions'], 'general', 'editFullProfile');
    } /* END canEditFullUser */

    protected function _subAccountsCheck()
    {
        if (XenForo_Application::$versionId >= 1020000) {
            $addOns = XenForo_Application::get('addOns');
            if (isset($addOns['Waindigo_SubAccounts'])) {
                return true;
            }
        } else {
            /* @var $addOnModel XenForo_Model_AddOn */
            $addOnModel = XenForo_Model::create('XenForo_Model_AddOn');
            $addOn = $addOnModel->getAddOnById('Waindigo_SubAccounts');
            if ($addOn && $addOn['active']) {
                return true;
            }
        }
        return false;
    } /* END _subAccountsCheck */
}