<?php

/**
 * Admin controller for advanced upgrades, used to show log and entry details
 */
class Waindigo_UserUpgrades_ControllerAdmin_AdvancedUpgrades extends XenForo_ControllerAdmin_Abstract
{

    /**
     *
     * @var int entries to show per page
     */
    protected $perPage = 100;

    /**
     * View log entries
     *
     * @return $this->responseView()
     */
    public function actionLog()
    {
        if (XenForo_Application::$versionId >= 1030000) {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL_PERMANENT, XenForo_Link::buildAdminLink('user-upgrades/transaction-log'));
        }

        $criteria = $this->_input->filterSingle('criteria', XenForo_Input::ARRAY_SIMPLE);

        $filter = $this->_input->filterSingle('_filter', XenForo_Input::ARRAY_SIMPLE);
        if ($filter && isset($filter['value'])) {
            $criteria['search'] = $filter['value'] . '%';

            if ($filter['prefix'] != true) {
                $criteria['search'] = '%' . $criteria['search'];
            }

            $filterView = true;
        } else {
            $filterView = false;
        }

        $order = $this->_input->filterSingle('order', XenForo_Input::STRING);
        $direction = $this->_input->filterSingle('direction', XenForo_Input::STRING);

        $inputData = (object) $this->_input->filter(
            array(
                'page' => array(
                    XenForo_Input::INT,
                    array(
                        'default' => 1
                    )
                )
            ));

        $fetchOptions = array(
            'limit' => $this->perPage,
            'offset' => ($inputData->page * $this->perPage) - $this->perPage,

            'order' => $order,
            'direction' => $direction
        );

        $upgradeModel = $this->getModelFromCache('XenForo_Model_UserUpgrade');
        $transactions = $upgradeModel->getTransactionLog($criteria, $fetchOptions);

        $view = $filterView ? 'waindigo_transaction_log_items_userupgrades' : 'waindigo_transaction_log_userupgrades';

        return $this->responseView('Waindigo_UserUpgrades_ViewAdmin_AdvancedUpgrades', $view,
            array(
                'linkParams' => array(
                    'criteria' => $criteria,
                    'order' => $order,
                    'direction' => $direction
                ),
                'total' => $upgradeModel->getTransactionLogCount(),
                'page' => $inputData->page,
                'perPage' => $this->perPage,
                'transactions' => $transactions
            ));
    } /* END actionLog */

    /**
     * View log entry
     *
     * @return $this->responseView()
     */
    public function actionView()
    {
        if (XenForo_Application::$versionId >= 1030000) {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL_PERMANENT, XenForo_Link::buildAdminLink('user-upgrades/transaction-log'));
        }

        $idTransaction = $this->_input->filterSingle('id', XenForo_Input::INT);

        $upgradeModel = $this->getModelFromCache('XenForo_Model_UserUpgrade');
        $transaction = $upgradeModel->getTransactionLogEntry($idTransaction);

        if (!$transaction) {
            return $this->responseError(new XenForo_Phrase('waindigo_requested_record_not_found_userupgrades'));
        }

        $transaction['transaction_details'] = unserialize($transaction['transaction_details']);

        return $this->responseView('Waindigo_UserUpgrades_ViewAdmin_AdvancedUpgrades',
            'waindigo_transaction_log_view_userupgrades',
            array(
                'transaction' => $transaction
            ));
    } /* END actionView */

    /**
     * View active upgrade entry
     *
     * @return $this->responseView()
     */
    public function actionViewActive()
    {
        $idRecord = $this->_input->filterSingle('id', XenForo_Input::INT);

        $upgradeModel = $this->getModelFromCache('XenForo_Model_UserUpgrade');
        $record = $upgradeModel->getActiveUserUpgradeRecordById($idRecord);

        if (!$record) {
            return $this->responseError(new XenForo_Phrase('waindigo_requested_record_not_found_userupgrades'));
        }

        $record['extra'] = unserialize($record['extra']);

        return $this->responseView('Waindigo_UserUpgrades_ViewAdmin_AdvancedUpgrades',
            'waindigo_active_record_view_userupgrades', array(
                'record' => $record
            ));
    } /* END actionViewActive */
}