<?php

/**
 * Data writer for upgrade categories.
 */
class Waindigo_UserUpgrades_DataWriter_UpgradeCategory extends XenForo_DataWriter
{

    /**
     * Title of the phrase that will be created when a call to set the
     * existing data fails (when the data doesn't exist).
     *
     * @var string
     */
    protected $_existingDataErrorPhrase = 'waindigo_requested_upgrade_category_not_found_userupgrades';

    /**
     * Gets the fields that are defined for the table.
     * See parent for explanation.
     *
     * @return array
     */
    protected function _getFields()
    {
        return array(
            'xf_upgrade_category' => array(
                'upgrade_category_id' => array(
                    'type' => self::TYPE_UINT,
                    'autoIncrement' => true
                ), /* END 'upgrade_category_id' */
                'title' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true
                ), /* END 'title' */
                'parent_category_id' => array(
                    'type' => self::TYPE_UINT,
                    'default' => 0
                ), /* END 'parent_category_id' */
                'display_order' => array(
                    'type' => self::TYPE_UINT,
                    'default' => 1
                ), /* END 'display_order' */
            ), /* END 'xf_upgrade_category' */
        );
    } /* END _getFields */

    /**
     * Gets the actual existing data out of data that was passed in.
     * See parent for explanation.
     *
     * @param mixed
     *
     * @return array false
     */
    protected function _getExistingData($data)
    {
        if (!$upgradeCategoryId = $this->_getExistingPrimaryKey($data, 'upgrade_category_id')) {
            return false;
        }

        $upgradeCategory = $this->_getUpgradeCategoryModel()->getUpgradeCategoryById($upgradeCategoryId);
        if (!$upgradeCategory) {
            return false;
        }

        return $this->getTablesDataFromArray($upgradeCategory);
    } /* END _getExistingData */

    /**
     * Gets SQL condition to update the existing record.
     *
     * @return string
     */
    protected function _getUpdateCondition($tableName)
    {
        return 'upgrade_category_id = ' . $this->_db->quote($this->getExisting('upgrade_category_id'));
    } /* END _getUpdateCondition */

    /**
     * Post-delete handling.
     */
    protected function _postDelete()
    {
        $this->_db->update('xf_user_upgrade', array(
            'upgrade_category_id' => 0
        ), 'upgrade_category_id = ' . $this->_db->quote($this->get('upgrade_category_id')));
    } /* END _postDelete */

    /**
     * Get the upgrade categories model.
     *
     * @return Waindigo_UserUpgrades_Model_UpgradeCategory
     */
    protected function _getUpgradeCategoryModel()
    {
        return $this->getModelFromCache('Waindigo_UserUpgrades_Model_UpgradeCategory');
    } /* END _getUpgradeCategoryModel */
}