<?php

/**
 * Extend Option controller to add necessary code to apply terminology
 */
class Waindigo_UserUpgrades_Extend_XenForo_ControllerAdmin_Option extends XFCP_Waindigo_UserUpgrades_Extend_XenForo_ControllerAdmin_Option
{

    /**
     *
     * @var array Phrases to handle
     */
    protected $_termPhrases = array(
        'account_upgrade',
        'account_upgrades',
        'account_upgrade_confirm',
        'account_upgrade_purchased',
        'active_user_upgrades',
        'available_upgrades',
        'no_account_upgrades_can_be_purchased_at_this_time',
        'purchased_upgrades'
    );

    /**
     * Extend save action to apply the terminology (if applicable)
     *
     * @see XenForo_ControllerAdmin_Option::actionSave()
     */
    public function actionSave()
    {
        $result = parent::actionSave();

        $options = $this->_input->filterSingle('options', XenForo_Input::ARRAY_SIMPLE);
        if ($options and isset($options['waindigo_userUpgrades_terminology'])) {
            $this->applyTerminology();
        }

        return $result;
    } /* END actionSave */

    /**
     * Apply the chosen terminology
     *
     * @return void
     */
    protected function applyTerminology()
    {
        // Get options the non-traditional way, as we don't want the cached
        // (outdated) version
        $options = XenForo_Model::create('XenForo_Model_Option')->rebuildOptionCache();
        $options = new XenForo_Options($options);

        $defaultLanguage = $options->defaultLanguageId;

        $phraseModel = new XenForo_Model_Phrase();
        $phrases = $phraseModel->getPhrasesInLanguageByTitles($this->_termPhrases, 0);

        // Loop through phrases to be modified
        foreach ($phrases as $phrase) {
            // Prepare data
            $data = $phrase;
            $data['language_id'] = $defaultLanguage;
            unset($data['phrase_id'], $data['version_id'], $data['version_string']);

            // Check for custom terminology
            if ($options->waindigo_userUpgrades_terminology != 'default') {
                // Detect plural or singular
                if (stripos($phrase['phrase_text'], 'upgrades') !== false) {
                    $replace = $options->waindigo_userUpgrades_terminologyPlural;
                } else {
                    $replace = $options->waindigo_userUpgrades_terminologySingular;
                }

                // Replace phrase text
                $data['phrase_text'] = preg_replace('/(\s)?(?:account|user)?\s?upgrades?/i', '$1' . $replace,
                    $phrase['phrase_text']);
            }

            // Get existing phrase for default language (if any)
            $existing = $phraseModel->getPhraseInLanguageByTitle($phrase['title'], $defaultLanguage);
            $writer = XenForo_DataWriter::create('XenForo_DataWriter_Phrase');

            if ($existing) {
                $writer->setExistingData($existing['phrase_id']);
            }

            // Save
            $writer->bulkSet($data);
            $writer->updateVersionId();
            $writer->save();
        }
    } /* END applyTerminology */
}