<?php

/**
 *
 * @see XenForo_ControllerAdmin_UserUpgrade
 */
class Waindigo_UserUpgrades_Extend_XenForo_ControllerAdmin_UserUpgrade extends XFCP_Waindigo_UserUpgrades_Extend_XenForo_ControllerAdmin_UserUpgrade
{

    const WAINDIGO_USERUPGRADES_HIDDENKEY = 'Waindigo_UserUpgrades_HiddenKey';

    /**
     * @see XenForo_ControllerAdmin_UserUpgrade::actionIndex()
     */
    public function actionIndex()
    {
        $upgradeModel = $this->_getUserUpgradeModel();
        $upgradeCategoryModel = $this->_getUpgradeCategoryModel();
        $optionModel = XenForo_Model::create('XenForo_Model_Option');
        
        $options = $optionModel->getOptionsByIds(array('payPalPrimaryAccount', 'payPalAlternateAccounts'));
        krsort($options); // just make sure the primary account is first
    
        $upgrades = $upgradeModel->prepareUserUpgrades($upgradeModel->getAllUserUpgrades());
        $upgradeCategories = $upgradeCategoryModel->getUpgradeCategories(array(),
            array(
                'order' => 'parent_category_id',
                'orderDirection' => 'asc'
            ));
        $parentUpgradeCategories = $upgradeCategoryModel->groupUpgradeCategoriesByParent($upgradeCategories);
        foreach ($upgrades as $upgradeId => $upgrade) {
            if ($upgrade['upgrade_category_id'] && isset($upgradeCategories[$upgrade['upgrade_category_id']])) {
                $parentUpgradeCategoryId = $upgradeCategories[$upgrade['upgrade_category_id']]['parent_category_id'];
            } else {
                $parentUpgradeCategoryId = 0;
            }
            $parentUpgradeCategories[$parentUpgradeCategoryId]['upgrade_categories'][$upgrade['upgrade_category_id']]['upgrades'][$upgradeId] = $upgrade;
        }

        $viewParams = array(
            'parentUpgradeCategories' => $parentUpgradeCategories,
            'upgradeCount' => count($upgrades),
            
            'options' => $optionModel->prepareOptions($options),
            'canEditOptionDefinition' => $optionModel->canEditOptionAndGroupDefinitions()
        );
    
        return $this->responseView('XenForo_ViewAdmin_UserUpgrade_List', 'user_upgrade_list',
            $viewParams);
    } /* END actionIndex */
    
    /**
     *
     * @see XenForo_ControllerAdmin_UserUpgrade::_getUpgradeAddEditResponse()
     */
    protected function _getUpgradeAddEditResponse(array $upgrade)
    {
        $upgrade = array_merge(
            array(
                'redirect' => '',
                'agreement' => '',
                'tiered_upgrade' => 0,
                'purchase_multiple' => 0,
                'notification_day' => 0,
                'tiered_upgrade' => 0,
                'required_group_ids' => '',
                'hidden' => 0,
                'permanent_group_ids' => '',
                'cost_amount_trial' => 0.00,
                'length_amount_post_trial' => 0,
                'length_unit_post_trial' => '',
                'tax_rate' => '0',
                'notification_day' => 0
            ), $upgrade);

        if ($upgrade['length_amount_post_trial'] && $upgrade['length_unit_post_trial']) {
            if ($upgrade['length_amount_post_trial'] == $upgrade['length_amount'] &&
                 $upgrade['length_unit_post_trial'] == $upgrade['length_unit'] && $upgrade['cost_amount_trial'] > 0) {
                $upgrade['cost_amount'] = $upgrade['cost_amount'] - $upgrade['cost_amount_trial'];
            } else {
                $upgrade['length_amount_trial'] = $upgrade['length_amount'];
                $upgrade['length_unit_trial'] = $upgrade['length_unit'];
                $upgrade['length_amount'] = $upgrade['length_amount_post_trial'];
                $upgrade['length_unit'] = $upgrade['length_unit_post_trial'];
                $tempCostAmount = $upgrade['cost_amount'] - $upgrade['cost_amount_trial'];
                $upgrade['cost_amount_trial'] = $upgrade['cost_amount'];
                $upgrade['cost_amount'] = $tempCostAmount;
                unset($tempCostAmount);
            }
        } else {
            $upgrade['cost_amount'] = $upgrade['cost_amount'] - $upgrade['cost_amount_trial'];
        }

        $upgrade['tax_rate'] = $upgrade['tax_rate'] + 0;

        if ($upgrade['length_unit']) {
            $upgrade['length_type'] = 'specified';
        } elseif ($upgrade['specific_end_date']) {
            $upgrade['length_type'] = 'specific_date';
        } else {
            $upgrade['length_type'] = 'permanent';
        }

        if ($upgrade['user_upgrade_id']) {
            $upgrade['hiddenUrl'] = XenForo_Link::buildPublicLink('account/purchase-confirm', '',
                array(
                    'upgrade_id' => $upgrade['user_upgrade_id'],
                    'key' => md5(
                        XenForo_Application::getSimpleCacheData(self::WAINDIGO_USERUPGRADES_HIDDENKEY) .
                             $upgrade['user_upgrade_id'])
                ));
        }

        /* @var $response XenForo_ControllerResponse_View */
        $response = parent::_getUpgradeAddEditResponse($upgrade);
        
        $upgradeCategories = $this->_getUpgradeCategoryModel()->getUpgradeCategories(array(),
            array(
                'order' => 'default',
                'orderDirection' => 'asc'
            ));
        
        $upgradeCategoryTitles = array();
        foreach ($upgradeCategories as $upgradeCategoryId => $category) {
            if ($category['parent_category_id'] != 0) {
                $upgradeCategoryTitles[$upgradeCategoryId] = $category['title'];
            }
        }
        
        if (!empty($upgradeCategoryTitles)) {
            $response->params['upgradeCategories'] = $upgradeCategoryTitles;
        }
        $response->params['requiredUserGroupOptions'] = $this->getModelFromCache('XenForo_Model_UserGroup')->getUserGroupOptions(
            $upgrade['required_group_ids']);
        $response->params['permanentUserGroupOptions'] = $this->getModelFromCache('XenForo_Model_UserGroup')->getUserGroupOptions(
            $upgrade['permanent_group_ids']);

        return $response;
    } /* END _getUpgradeAddEditResponse */

    /**
     * Inserts a new upgrade or updates an existing one.
     *
     * @see XenForo_ControllerAdmin_UserUpgrade::actionSave()
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionSave()
    {
        $this->_assertPostOnly();

        $userUpgradeId = $this->_input->filterSingle('user_upgrade_id', XenForo_Input::UINT);
        $input = $this->_getInputFromForm();

        $this->_checkTieredUpgradeError($input);
        $input = $this->_overrideInputBasedOnLengthCheck($input);
        $input = $this->_overrideInputBasedOnRecurringCheck($input);

        $dw = XenForo_DataWriter::create('XenForo_DataWriter_UserUpgrade');
        if ($userUpgradeId) {
            $dw->setExistingData($userUpgradeId);
        }
        $dw->bulkSet($input);
        $dw->save();

        return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
            XenForo_Link::buildAdminLink('user-upgrades') . $this->getLastHash($dw->get('user_upgrade_id')));
    } /* END actionSave */

    /**
     * Form to edit end date of a user upgrade based on input.
     */
    public function actionEditEndDate()
    {
        $userUpgradeModel = $this->_getUserUpgradeModel();

        $upgrade = $this->_getUserUpgradeOrError($this->_input->filterSingle('user_upgrade_id', XenForo_Input::UINT));

        $user = $this->_getUserModel()->getUserById($this->_input->filterSingle('user_id', XenForo_Input::UINT));
        if (!$user) {
            return $this->responseError(new XenForo_Phrase('requested_user_not_found'));
        }

        $upgradeRecord = $userUpgradeModel->getActiveUserUpgradeRecord($user['user_id'], $upgrade['user_upgrade_id']);
        $hasEndDate = (isset($upgradeRecord['end_date']));

        if ($this->isConfirmedPost() && $hasEndDate) {
            $endDate = strtotime($this->_input->filterSingle('end_date', XenForo_Input::STRING) . ' 00:00:00');
            $userUpgradeModel->editEndDate($upgradeRecord, $endDate);
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, $this->getDynamicRedirect());
        } else {
            $viewParams = array(
                'upgrade' => $upgrade,
                'user' => $user,
                'upgradeRecord' => $upgradeRecord,
                'hasEndDate' => $hasEndDate,
                'redirect' => $this->getDynamicRedirect()
            );
            return $this->responseView('Waindigo_UserUpgrades_ViewAdmin_UserUpgrade_EditEndDate',
                'waindigo_edit_end_date_userupgrades', $viewParams);
        }
    } /* END actionEditEndDate */

    /**
     * Displays a form to search the list of active user upgrades
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionSearch()
    {
        $viewParams = array(
            'upgrades' => $this->_getUserUpgradeModel()->getAllUserUpgrades()
        );
        return $this->responseView('XenForo_ViewAdmin_UserUpgrade_Search', 'waindigo_search_upgrades_userupgrades',
            $viewParams);
    } /* END actionSearch */

    public function actionHistory()
    {
        $input = $this->_input->filter(
            array(
                'username' => XenForo_Input::STRING,
                'user_id' => XenForo_Input::UINT,
                'user_upgrade_id' => XenForo_Input::UINT
            ));

        $user = false;
        $upgrade = false;

        if ($input['user_id']) {
            $user = $this->_getUserModel()->getUserById($input['user_id']);
            if (!$user) {
                return $this->responseError(new XenForo_Phrase('requested_user_not_found'));
            }
        }

        if ($input['username']) {
            $user = $this->_getUserModel()->getUserByName($input['username']);
            if (!$user) {
                return $this->responseError(new XenForo_Phrase('requested_user_not_found'));
            }

            $input['user_id'] = $user['user_id'];
        }

        if ($input['user_upgrade_id']) {
            $upgrade = $this->_getUserUpgradeOrError($input['user_upgrade_id']);
        }

        $linkParams = array();
        if ($input['user_upgrade_id']) {
            $linkParams['user_upgrade_id'] = $input['user_upgrade_id'];
        }
        if ($input['user_id']) {
            $linkParams['user_id'] = $input['user_id'];
        }

        if ($this->_request->isPost()) {
            // redirect to a get request approach
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,
                XenForo_Link::buildAdminLink('user-upgrades/history', false, $linkParams));
        }

        $userUpgradeModel = $this->_getUserUpgradeModel();

        $page = $this->_input->filterSingle('page', XenForo_Input::UINT);
        $perPage = 20;

        $conditions = array(
            'active' => 1,
            'user_upgrade_id' => $input['user_upgrade_id'],
            'user_id' => $input['user_id']
        );

        $upgradeRecords = $userUpgradeModel->getUserUpgradeRecords($conditions,
            array(
                'join' => XenForo_Model_UserUpgrade::JOIN_UPGRADE,
                'page' => $page,
                'perPage' => $perPage
            ));
        $totalRecords = $userUpgradeModel->countUserUpgradeRecords($conditions);

        $this->canonicalizePageNumber($page, $perPage, $totalRecords, 'user-upgrades/history');

        $viewParams = array(
            'upgradeRecords' => $upgradeRecords,
            'totalRecords' => $totalRecords,

            'page' => $page,
            'perPage' => $perPage,
            'linkParams' => $linkParams
        );
        return $this->responseView('XenForo_ViewAdmin_UserUpgrade_History', 'waindigo_upgrade_history_userupgrades',
            $viewParams);
    } /* END actionHistory */

    public function actionExport()
    {
        $userUpgradeId = $this->_input->filterSingle('user_upgrade_id', XenForo_Input::UINT);
        $userUpgrade = $this->_getUserUpgradeOrError($userUpgradeId);

        $this->_routeMatch->setResponseType('xml');

        $viewParams = array(
            'userUpgrade' => $userUpgrade,
            'xml' => $this->_getUserUpgradeModel()->getUserUpgradeXml($userUpgrade)
        );

        return $this->responseView('Waindigo_MoreAdvancedUpg_ViewAdmin_UserUpgrade_Export', '', $viewParams);
    } /* END actionExport */

    public function actionImport()
    {
        $userUpgradeModel = $this->_getUserUpgradeModel();

        if ($this->isConfirmedPost()) {
            $input = $this->_input->filter(
                array(
                    'target' => XenForo_Input::STRING,
                    'overwrite_user_upgrade_id' => XenForo_Input::UINT
                ));

            $upload = XenForo_Upload::getUploadedFile('upload');
            if (!$upload) {
                return $this->responseError(
                    new XenForo_Phrase('waindigo_please_upload_valid_user_upgrade_xml_file_userupgrades'));
            }

            if ($input['target'] == 'overwrite') {
                $this->_getUserUpgradeOrError($input['overwrite_user_upgrade_id']);
            } else {
                $input['overwrite_user_upgrade_id'] = 0;
            }

            $document = $this->getHelper('Xml')->getXmlFromFile($upload);
            $caches = $userUpgradeModel->importUserUpgradeXml($document, $input['overwrite_user_upgrade_id']);

            return XenForo_CacheRebuilder_Abstract::getRebuilderResponse($this, $caches,
                XenForo_Link::buildAdminLink('user-upgrades'));
        } else {
            $viewParams = array(
                'userUpgrades' => $userUpgradeModel->getAllUserUpgrades()
            );

            return $this->responseView('Waindigo_UserUpgrades_ViewAdmin_UserUpgrade_Import',
                'waindigo_user_upgrade_import_userupgrades', $viewParams);
        }
    } /* END actionImport */

    /**
     *
     * @return XenForo_Model_User
     */
    protected function _getUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    } /* END _getUserModel */

    /**
     *
     * @return $input
     */
    protected function _getInputFromForm()
    {
        $input = $this->_input->filter(
            array(
                'title' => XenForo_Input::STRING,
                'description' => XenForo_Input::STRING,
                'redirect' => XenForo_Input::STRING,
                'agreement' => XenForo_Input::STRING,
                'display_order' => XenForo_Input::UINT,
                'tiered_upgrade' => XenForo_INPUT::UINT,
                'hidden' => XenForo_INPUT::UINT,
                'extra_group_ids' => array(
                    XenForo_Input::UINT,
                    'array' => true
                ),
                'permanent_group_ids' => array(
                    XenForo_Input::UINT,
                    'array' => true
                ),
                'recurring' => XenForo_Input::UINT,
                'cost_amount' => XenForo_Input::UNUM,
                'cost_currency' => XenForo_Input::STRING,
                'length_amount' => XenForo_Input::UINT,
                'length_unit' => XenForo_Input::STRING,
                'specific_end_date' => XenForo_Input::STRING,
                'disabled_upgrade_ids' => array(
                    XenForo_Input::UINT,
                    'array' => true
                ),
                'can_purchase' => XenForo_Input::UINT,
                'purchase_multiple' => XenForo_Input::UINT,
                'cost_amount_trial' => XenForo_Input::UNUM,
                'length_amount_trial' => XenForo_Input::UINT,
                'length_unit_trial' => XenForo_Input::STRING,
                'tax_rate' => XenForo_Input::UNUM,
                'paypal_email' => XenForo_Input::STRING,
                'notification_day' => XenForo_Input::UINT,
                'required_group_ids' => array(
                    XenForo_Input::UINT,
                    'array' => true
                ),
                'upgrade_category_id' => XenForo_Input::UINT,
            ));
        return $input;
    } /* END _getInputFromForm */

    protected function _checkTieredUpgradeError(array $input)
    {
        if ($input['recurring'] && $input['tiered_upgrade']) {
            throw $this->responseException(
                $this->responseError(new XenForo_Phrase('waindigo_tiered_upgrade_error_userupgrades')));
        }
    } /* END _checkTieredUpgradeError */

    protected function _overrideInputBasedOnLengthCheck(array $input)
    {
        if (in_array($this->_input->filterSingle('length_type', XenForo_Input::STRING),
            array(
                'permanent',
                'specific_date'
            ))) {
            $input['length_amount'] = 0;
            $input['length_unit'] = '';
        }
        return $input;
    } /* END _overrideInputBasedOnLengthCheck */

    protected function _overrideInputBasedOnRecurringCheck(array $input)
    {
        if ($input['recurring']) {
            $input['notification_day'] = 0;
            if ($input['length_amount_trial'] && $input['length_unit_trial']) {
                $input['length_amount_post_trial'] = $input['length_amount'];
                $input['length_amount'] = $input['length_amount_trial'];
                $input['length_unit_post_trial'] = $input['length_unit'];
                $input['length_unit'] = $input['length_unit_trial'];
                $costAmount = $input['cost_amount_trial'];
                $input['cost_amount_trial'] = $input['cost_amount_trial'] - $input['cost_amount'];
                $input['cost_amount'] = $costAmount;
            } else {
                $input['cost_amount'] = $input['cost_amount_trial'] + $input['cost_amount'];
                $input['cost_amount_trial'] = $input['cost_amount_trial'];
            }
        } else {
            $input['length_amount_post_trial'] = 0;
            $input['length_unit_post_trial'] = '';
        }
        unset($input['length_amount_trial'], $input['length_unit_trial']);

        return $input;
    } /* END _overrideInputBasedOnRecurringCheck */
    
    /**
     * Get the upgrade categories model.
     *
     * @return Waindigo_UserUpgrades_Model_UpgradeCategory
     */
    protected function _getUpgradeCategoryModel()
    {
        return $this->getModelFromCache('Waindigo_UserUpgrades_Model_UpgradeCategory');
    } /* END _getUpgradeCategoryModel */
    
}