<?php

/**
 *
 * @see XenForo_ControllerPublic_Account
 */
class Waindigo_UserUpgrades_Extend_XenForo_ControllerPublic_Account extends XFCP_Waindigo_UserUpgrades_Extend_XenForo_ControllerPublic_Account
{

    const WAINDIGO_USERUPGRADES_HIDDENKEY = 'Waindigo_UserUpgrades_HiddenKey';

    /**
     *
     * @see XenForo_ControllerPublic_Account::actionUpgrades()
     */
    public function actionUpgrades()
    {
        /* @var $response XenForo_ControllerResponse_View */
        $response = parent::actionUpgrades();
        
        if ($response instanceof XenForo_ControllerResponse_View) {
            foreach ($response->subView->params['available'] as $upgradeId => $upgrade) {
                if ($upgrade['hidden']) {
                    unset($response->subView->params['available'][$upgradeId]);
                }
            }
            
            if (!$response->subView->params['available'] && !$response->subView->params['purchased']) {
                return $this->responseMessage(new XenForo_Phrase('no_account_upgrades_can_be_purchased_at_this_time'));
            }
            
            if ($response->subView->params['available']) {
                $available = $response->subView->params['available'];
                /* @var $upgradeCategoryModel Waindigo_Trophies_Model_UpgradeCategory */
                $upgradeCategoryModel = $this->_getUpgradeCategoryModel();
                $upgradeCategories = $upgradeCategoryModel->getUpgradeCategories(array(),
                    array(
                        'order' => 'default',
                        'orderDirection' => 'asc'
                    ));
                $parentUpgradeCategories = $upgradeCategoryModel->groupUpgradeCategoriesByParent($upgradeCategories);
                foreach ($available as $upgradeId => $upgrade) {
                    if ($upgrade['upgrade_category_id']) {
                        $parentUpgradeCategoryId = $upgradeCategories[$upgrade['upgrade_category_id']]['parent_category_id'];
                    } else {
                        $parentUpgradeCategoryId = 0;
                    }
                    $parentUpgradeCategories[$parentUpgradeCategoryId]['upgrade_categories'][$upgrade['upgrade_category_id']]['upgrades'][$upgradeId] = $upgrade;
                }
                $response->subView->params['parentUpgradeCategories'] = $parentUpgradeCategories;
                $response->subView->params['available'] = array();
            }
            
            $options = XenForo_Application::get('options');
            $response->subView->params['usePopUp'] = $options->waindigo_userUpgrades_disablePopin == false;
        }
        
        return $response;
    } /* END actionUpgrades */

    /**
     * Purchase an upgrade
     *
     * @see XenForo_ControllerPublic_Account::actionPurchaseConfirm()
     *
     * @return $this->responseView()
     */
    public function actionPurchaseConfirm()
    {
        $visitor = XenForo_Visitor::getInstance();
        if ($visitor->user_id == 0) {
            return $this->actionPurchaseGuest();
        }
        
        $upgrade = $this->getRequestedUpgrade();
        
        $upgradeId = $upgrade['user_upgrade_id'];
        
        $viewParams = array(
            'upgrade' => $upgrade,
            'payPalUrl' => 'https://www.paypal.com/cgi-bin/websrc'
        );
        
        if ($upgrade['hidden']) {
            $upgradeKey = md5(
                XenForo_Application::getSimpleCacheData(self::WAINDIGO_USERUPGRADES_HIDDENKEY) . $upgradeId);
            $viewParams['key'] = $upgradeKey;
        }
        
        return $this->_getWrapper('account', 'upgrades', 
            $this->responseView('Waindigo_UserUpgrades_ViewPublic_PurchaseConfirm', 
                'waindigo_account_upgrades_confirm_userupgrades', $viewParams));
    } /* END actionPurchaseConfirm */

    /**
     * Purchase upgrade as guest (embed registration form)
     *
     * @return $this->responseView()
     */
    public function actionPurchaseGuest()
    {
        $options = XenForo_Application::get('options');
        
        // Disable guest purchases
        if ($options->waindigo_userUpgrades_disableGuest || !$options->get('registrationSetup', 'enabled')) {
            return $this->responseError(new XenForo_Phrase('waindigo_login_required_userupgrades'));
        }
        
        $upgrade = $this->getRequestedUpgrade();
        $upgradeId = $upgrade['user_upgrade_id'];
        
        $upgradeModel = $this->getModelFromCache('XenForo_Model_UserUpgrade');
        $purchaseList = $upgradeModel->getUserUpgradesForPurchaseList();
        
        if (!$purchaseList['available']) {
            return $this->responseMessage(
                new XenForo_Phrase('waindigo_no_account_upgrades_can_be_purchased_at_this_time_userupgrades'));
        }
        
        $upgrade = false;
        foreach ($purchaseList['available'] as $purchase) {
            if ($purchase['user_upgrade_id'] == $upgradeId) {
                $upgrade = $purchase;
            }
        }
        
        $viewParams = array(
            'captcha' => XenForo_Captcha_Abstract::createDefault(),
            'tosUrl' => XenForo_Dependencies_Public::getTosUrl(),
            
            'upgrade' => $upgrade,
            'payPalUrl' => 'https://www.paypal.com/cgi-bin/websrc'
        );
        
        return $this->_getWrapper('account', 'upgrades', 
            $this->responseView('Waindigo_UserUpgrades_ViewPublic_PurchaseGuest', 
                'waindigo_account_upgrades_register_userupgrades', $viewParams));
    } /* END actionPurchaseGuest */

    /**
     * Perform registration and initiate purchase
     *
     * @return $this->responseRedirect()
     */
    public function actionPurchaseRegister()
    {
        $options = XenForo_Application::get('options');
        
        // Disable guest purchases
        if ($options->waindigo_userUpgrades_disableGuest || !$options->get('registrationSetup', 'enabled')) {
            return $this->responseError(new XenForo_Phrase('waindigo_login_required_userupgrades'));
        }
        
        $writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
        
        $data = $this->_input->filter(
            array(
                'username' => XenForo_Input::STRING,
                'email' => XenForo_Input::STRING
            ));
        $upgradeId = $this->_input->filterSingle('upgrade_id', XenForo_Input::INT);
        $password = $this->_input->filterSingle('password', XenForo_Input::STRING);
        
        // Set registration details
        if ($options->registrationDefaults) {
            $writer->bulkSet($options->registrationDefaults, 
                array(
                    'ignoreInvalidFields' => true
                ));
        }
        
        // Set registration data
        $data['user_group_id'] = XenForo_Model_User::$defaultRegisteredGroupId;
        $data['language_id'] = XenForo_Visitor::getInstance()->get('language_id');
        
        $writer->bulkSet($data);
        $writer->setPassword($password, $password);
        
        $writer->advanceRegistrationUserState();
        $writer->preSave();
        
        if ($errors = $writer->getErrors()) {
            return $this->responseError($errors);
        }
        
        $writer->save();
        
        $user = $writer->getMergedData();
        
        // Log login
        XenForo_Model_Ip::log($user['user_id'], 'user', $user['user_id'], 'login');
        
        // Delete session activity to this point (we're starting a new one)
        $userModel = new XenForo_Model_User();
        $userModel->deleteSessionActivity(0, $this->_request->getClientIp(false));
        
        // Get active session and update it with the newly logged in user id
        $session = XenForo_Application::get('session');
        $session->changeUserId($user['user_id']);
        
        // Set up visitor instance
        XenForo_Visitor::setup($user['user_id']);
        
        $payPalUrl = $this->_input->filterSingle('payPalUrl', XenForo_Input::STRING);
        if (!$payPalUrl) {
            $payPalUrl = 'https://www.paypal.com/cgi-bin/websrc';
        }
        
        return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 
            XenForo_Link::buildPublicLink('account/purchase-redirect', null, 
                array(
                    'upgrade_id' => $upgradeId,
                    'payPalUrl' => $payPalUrl
                )));
    } /* END actionPurchaseRegister */

    /**
     * Redirect purchase to paypal
     *
     * @return XenForo_ControllerResponse_View
     */
    public function actionPurchaseRedirect()
    {
        $visitor = XenForo_Visitor::getInstance();
        $options = XenForo_Application::get('options');
        $upgrade = $this->getRequestedUpgrade();
        
        // Differentiate between permanent and recurring upgrades
        if ($upgrade['length_unit'] and $upgrade['recurring']) {
            $params = array(
                'cmd' => '_xclick-subscriptions',
                'a3' => $upgrade['cost_amount'],
                'p3' => $upgrade['length_amount'],
                't3' => $upgrade['lengthUnitPP'],
                'src' => 1,
                'sra' => 1
            );
            if ($upgrade['length_amount_trial'] && $upgrade['lengthUnitTrialPP']) {
                $params['a1'] = $upgrade['cost_amount_trial'];
                $params['p1'] = $upgrade['length_amount_trial'];
                $params['t1'] = $upgrade['lengthUnitTrialPP'];
            } elseif ($upgrade['cost_amount_trial'] + $upgrade['cost_amount']) {
                $params['a1'] = $upgrade['cost_amount_trial'] + $upgrade['cost_amount'];
                $params['p1'] = $upgrade['length_amount'];
                $params['t1'] = $upgrade['lengthUnitPP'];
            }
        } else {
            $params = array(
                'cmd' => '_xclick',
                'amount' => $upgrade['cost_amount']
            );
        }
        
        // If upgrade doesn't have a custom redirect revert back to default
        if (!empty($upgrade['redirect'])) {
            $redirect = XenForo_Link::buildPublicLink('full:account/upgrade-purchase', null, 
                array(
                    'upgrade_id' => $upgrade['user_upgrade_id']
                ));
        } else {
            $redirect = XenForo_Link::buildPublicLink('full:account/upgrade-purchase');
        }
        
        $paths = XenForo_Application::getRequestPaths(new Zend_Controller_Request_Http());
        $baseUrl = $paths['fullBasePath'];
        
        $payPalEmail = $upgrade['paypal_email'] ? $upgrade['paypal_email'] : $options->payPalPrimaryAccount;
        
        // Set additional paypal params
        $params = array_merge($params, 
            array(
                'business' => $payPalEmail,
                'currency_code' => $upgrade['currency'],
                'item_name' => $upgrade['title'],
                'quantity' => 1,
                'no_note' => 1,
                'no_shipping' => $options->waindigo_userUpgrades_shippingDefault,
                'custom' => implode(',', 
                    array(
                        $visitor->user_id,
                        $upgrade['user_upgrade_id'],
                        'token',
                        $visitor->csrf_token_page
                    )),
                'charset' => 'utf-8',
                'email' => $visitor->email,
                'return' => $redirect,
                'cancel_return' => XenForo_Link::buildPublicLink('full:account/upgrades'),
                'notify_url' => $baseUrl . 'payment_callback.php'
            ));
        
        $payPalUrl = $this->_input->filterSingle('payPalUrl', XenForo_Input::STRING);
        if (!$payPalUrl) {
            $payPalUrl = 'https://www.paypal.com/cgi-bin/websrc';
        }
        
        // Redirect to paypal
        $url = $payPalUrl . '?' . XenForo_Link::buildQueryString($params);
        
        header('Location: ' . $url);
        exit();
    } /* END actionPurchaseRedirect */

    /**
     *
     * @see XenForo_ControllerPublic_Account::actionUpgradePurchase()
     */
    public function actionUpgradePurchase()
    {
        $upgradeId = $this->_input->filterSingle('upgrade_id', XenForo_Input::INT);
        $upgradeModel = $this->getModelFromCache('XenForo_Model_UserUpgrade');
        $upgrade = $upgradeModel->getUserUpgradeById($upgradeId);
        
        if (!$upgrade || !$upgrade['redirect']) {
            return parent::actionUpgradePurchase();
        }
        
        $redirect = $upgrade['redirect'];
        
        // Detect type of redirect value and redirect accordingly
        if (substr($redirect, 0, 1) == '/' or substr($redirect, 0, 4) == 'http') {
            header("Location: " . $redirect);
            exit();
        } else {
            return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 
                XenForo_Link::buildPublicLink($redirect));
        }
    } /* END actionUpgradePurchase */

    /**
     * Show license agreement for upgrade
     *
     * @return $this->responseView()
     */
    public function actionUpgradeAgreement()
    {
        $upgradeId = $this->_input->filterSingle('upgrade_id', XenForo_Input::INT);
        $upgradeModel = $this->getModelFromCache('XenForo_Model_UserUpgrade');
        $upgrade = $upgradeModel->getUserUpgradeById($upgradeId);
        
        if (!$upgrade) {
            throw new XenForo_Exception(new XenForo_Phrase('requested_user_upgrade_not_found'), true);
        }
        
        $options = XenForo_Application::get('options');
        
        $viewParams = array(
            'upgrade' => $upgrade,
            'usePopUp' => $options->waindigo_userUpgrades_disablePopin == false
        );
        
        return $this->_getWrapper('account', 'upgrades', 
            $this->responseView('Waindigo_UserUpgrades_ViewPublic_UpgradeAgreement', 
                'waindigo_account_upgrade_agreement_userupgrades', $viewParams));
    } /* END actionUpgradeAgreement */

    protected function _preDispatch($action)
    {
        $options = XenForo_Application::get('options');
        
        if (!$options->waindigo_userUpgrades_disableGuest) {
            if (in_array(strtolower($action), 
                array(
                    'upgrades',
                    'purchaseconfirm',
                    'purchaseguest',
                    'purchaseregister',
                    'purchaseredirect',
                    'purchase',
                    'upgradeagreement'
                ))) {
                return;
            }
        }
        
        return parent::_preDispatch($action);
    } /* END _preDispatch */

    /**
     * Get requested upgrade information
     *
     * @return array
     */
    protected function getRequestedUpgrade()
    {
        if (!$upgradeId = $this->_input->filterSingle('upgrade_id', XenForo_Input::INT)) {
            throw new XenForo_Exception(new XenForo_Phrase('requested_user_upgrade_not_found'), true);
        }
        
        /* @var $upgradeModel XenForo_Model_UserUpgrade */
        $upgradeModel = $this->getModelFromCache('XenForo_Model_UserUpgrade');
        $purchaseList = $upgradeModel->getUserUpgradesForPurchaseList();
        
        if (!$purchaseList['available']) {
            throw new XenForo_Exception(new XenForo_Phrase('no_account_upgrades_can_be_purchased_at_this_time'), true);
        }
        
        $upgrade = false;
        foreach ($purchaseList['available'] as $purchase) {
            if ($purchase['user_upgrade_id'] == $upgradeId) {
                $upgrade = $purchase;
            }
        }
        
        //Addition for compatibility with upgrade coupons
        if (!$upgrade && $this->_upgradeCouponsCheck()) {
            if (!empty($purchaseList['giftUpgrades'])) {
                foreach ($purchaseList['giftUpgrades'] as $purchase) {
                    if ($purchase['user_upgrade_id'] == $upgradeId) {
                        $upgrade = $purchase;
                        $couponModel = $this->_getCouponModel();
                        $coupon = $couponModel->getCouponFromUserId(XenForo_Visitor::getUserId());
                        if (!empty($coupon)) {
                            if ($couponModel->checkCouponWithUpgrade($coupon, $upgrade)) {
                                $upgrade = $couponModel->applyCouponToUpgrade($upgrade, $coupon);
                            }
                        }
                    }
                }
            }
        }
        
        if ($upgrade == false) {
            throw new XenForo_Exception(new XenForo_Phrase('requested_user_upgrade_not_found'), true);
        }
        
        if ($upgrade['hidden']) {
            $upgradeKey = md5(
                XenForo_Application::getSimpleCacheData(self::WAINDIGO_USERUPGRADES_HIDDENKEY) . $upgradeId);
            if ($this->_input->filterSingle('key', XenForo_Input::STRING) != $upgradeKey) {
                throw new XenForo_Exception(new XenForo_Phrase('requested_user_upgrade_not_found'), true);
            }
        }
        
        return $upgradeModel->prepareUserUpgrade($upgrade);
    } /* END getRequestedUpgrade */

    protected function _upgradeCouponsCheck()
    {
        if (XenForo_Application::$versionId >= 1020000) {
            $addOns = XenForo_Application::get('addOns');
            if (isset($addOns['Waindigo_UpgradeCoupons'])) {
                return true;
            }
        } else {
            /* @var $addOnModel XenForo_Model_AddOn */
            $addOnModel = XenForo_Model::create('XenForo_Model_AddOn');
            $addOn = $addOnModel->getAddOnById('Waindigo_UpgradeCoupons');
            if ($addOn && $addOn['active']) {
                return true;
            }
        }
        return false;
    } /* END _upgradeCouponsCheck */

    /**
     *
     * @see XenForo_ControllerPublic_Account::_getWrapper()
     */
    protected function _getWrapper($selectedGroup, $selectedLink, XenForo_ControllerResponse_View $subView)
    {
        if (!XenForo_Visitor::getUserId()) {
            $wrapper = $this->responseView('Waindigo_UserUpgrades_ViewPublic_GuestWrapper', 
                'waindigo_guest_wrapper_userupgrades');
            $wrapper->subView = $subView;
            
            return $wrapper;
        }
        return parent::_getWrapper($selectedGroup, $selectedLink, $subView);
    } /* END _getWrapper */
    
    /**
     * Get the upgrade categories model.
     *
     * @return Waindigo_UserUpgrades_Model_UpgradeCategory
     */
    protected function _getUpgradeCategoryModel()
    {
        return $this->getModelFromCache('Waindigo_UserUpgrades_Model_UpgradeCategory');
    } /* END _getUpgradeCategoryModel */
}