<?php

/**
 *
 * @see XenForo_DataWriter_User
 */
class Waindigo_UserUpgrades_Extend_XenForo_DataWriter_User extends XFCP_Waindigo_UserUpgrades_Extend_XenForo_DataWriter_User
{

    protected function _getFields()
    {
        $fields = parent::_getFields();
        $fields['xf_user']['user_state']['allowedValues'][] = 'paypal_pending';

        return $fields;
    } /* END _getFields */

    /**
     * Advances the user state forward one step, following the registration
     * rules.
     *
     * @see XenForo_DataWriter_User::advanceRegistrationUserState()
     *
     * @param boolean $allowEmailConfirmAdvanceRegistrationUserState()
     */
    public function advanceRegistrationUserState($allowEmailConfirm = true)
    {
        $options = XenForo_Application::get('options');

        if ($this->isInsert()) {
            if (!$this->get('user_state')) {
                if ($options->get('waindigo_userUpgrades_paidRegistration')) {
                    $this->set('user_state', 'paypal_pending');
                }
            }
        } else {
            if ($this->get('user_state') == 'paypal_pending') {
                $this->set('user_state', 'email_confirm');
                if (!$options->get('waindigo_userUpgrades_emailConfirmOverride') && $options->get('registrationSetup', 'emailConfirmation') && $allowEmailConfirm) {
                    return;
                }
            }
        }

        parent::advanceRegistrationUserState($allowEmailConfirm);
    } /* END advanceRegistrationUserState */
}