<?php

/**
 * Extend UserUpgrade datawriter to support additional fields
 *
 * @see XenForo_DataWriter_UserUpgrade
 */
class Waindigo_UserUpgrades_Extend_XenForo_DataWriter_UserUpgrade extends XFCP_Waindigo_UserUpgrades_Extend_XenForo_DataWriter_UserUpgrade
{

    protected function _getFields()
    {
        $fields = parent::_getFields();
        $fields['xf_user_upgrade']['purchase_multiple'] = array(
            'type' => self::TYPE_BOOLEAN,
            'default' => 1
        );
        $fields['xf_user_upgrade']['hidden'] = array(
            'type' => self::TYPE_BOOLEAN,
            'default' => 0
        );
        $fields['xf_user_upgrade']['agreement'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );
        $fields['xf_user_upgrade']['redirect'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );
        $fields['xf_user_upgrade']['tiered_upgrade'] = array(
            'type' => self::TYPE_BOOLEAN,
            'default' => 0
        );
        $fields['xf_user_upgrade']['specific_end_date'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );
        $fields['xf_user_upgrade']['cost_amount_trial'] = array(
            'type' => self::TYPE_FLOAT,
            'default' => '0.00'
        );
        $fields['xf_user_upgrade']['length_amount_post_trial'] = array(
            'type' => self::TYPE_UINT,
            'default' => '0'
        );
        $fields['xf_user_upgrade']['length_unit_post_trial'] = array(
            'type' => self::TYPE_STRING,
            'default' => '',
            'allowedValues' => array(
                'day',
                'month',
                'year',
                ''
            )
        );
        $fields['xf_user_upgrade']['tax_rate'] = array(
            'type' => self::TYPE_FLOAT,
            'default' => '0.000'
        );
        $fields['xf_user_upgrade']['paypal_email'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );
        $fields['xf_user_upgrade']['notification_day'] = array(
            'type' => self::TYPE_UINT,
            'default' => '0'
        );
        $fields['xf_user_upgrade']['permanent_group_ids'] = array(
            'type' => self::TYPE_UNKNOWN,
            'default' => '',
            'verification' => array(
                'XenForo_DataWriter_Helper_User',
                'verifyExtraUserGroupIds'
            )
        );
        $fields['xf_user_upgrade']['required_group_ids'] = array(
            'type' => self::TYPE_UNKNOWN,
            'default' => '',
            'verification' => array(
                'XenForo_DataWriter_Helper_User',
                'verifyExtraUserGroupIds'
            )
        );
        $fields['xf_user_upgrade']['upgrade_category_id'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0
        );
        

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see XenForo_DataWriter_UserUpgrade::_verifyCostAmount()
     */
    protected function _verifyCostAmount(&$cost)
    {
        if ($cost == 0 && $this->get('cost_amount_trial')) {
            return true;
        }
        return parent::_verifyCostAmount($cost);
    } /* END _verifyCostAmount */
}