<?php

/**
 *
 * @see Waindigo_Install
 */
class Waindigo_UserUpgrades_Install_Controller extends Waindigo_Install
{

    const WAINDIGO_USERUPGRADES_HIDDENKEY = 'Waindigo_UserUpgrades_HiddenKey';

    protected $_resourceManagerUrl = 'http://xenforo.com/community/resources/user-upgrades-by-waindigo.861/';

    protected function _preInstall()
    {
        self::$_noUninstall = true;
        $addOn = $this->getModelFromCache('XenForo_Model_AddOn')->getAddOnById('Waindigo_MoreAdvancedUpg');

        if ($addOn) {
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_AddOn');
            $dw->setExistingData($addOn);
            $dw->delete();
        }
        self::$_noUninstall = false;

        $addOn = $this->getModelFromCache('XenForo_Model_AddOn')->getAddOnById('AdvancedUpgrades');

        if ($addOn) {
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_AddOn');
            $dw->setExistingData($addOn);
            $dw->delete();
        }
    } /* END _preInstall */
    
    protected function _getTables()
    {
        return array(
            'xf_upgrade_category' => array(
                'upgrade_category_id' => 'INT(10) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY', /* END 'upgrade_category_id' */
                'title' => 'VARCHAR(255) NOT NULL', /* END 'title' */
                'parent_category_id' => 'INT(10) UNSIGNED NOT NULL DEFAULT 0', /* END 'parent_category_id' */
                'display_order' => 'INT(3) UNSIGNED NOT NULL DEFAULT 1', /* END 'display_order' */
            ), /* END 'xf_upgrade_category' */
        );
    } /* END _getTables */

    protected function _getTableChanges()
    {
        return array(
            'xf_user_upgrade' => array(
                'purchase_multiple' => 'TINYINT(3) UNSIGNED NOT NULL DEFAULT 0', /* 'purchase_multiple' */
    			'agreement' => 'MEDIUMTEXT', /* 'agreement' */
    			'redirect' => 'TEXT', /* 'redirect' */
                'tiered_upgrade' => 'BOOLEAN NOT NULL DEFAULT 0', /* 'tiered_upgrade */
                'hidden' => 'BOOLEAN NOT NULL DEFAULT 0', /* 'hidden */
                'specific_end_date' => 'VARCHAR(255) NOT NULL DEFAULT \'\'', /* 'specific_end_date' */
                'cost_amount_trial' => 'DECIMAL(10, 2) NOT NULL DEFAULT 0', /* 'cost_amount_trial' */
                'length_amount_post_trial' => 'TINYINT(3) UNSIGNED NOT NULL DEFAULT 0', /* 'length_amount_post_trial' */
                'length_unit_post_trial' => 'ENUM(\'day\', \'month\', \'year\', \'\') DEFAULT \'\'', /* 'length_unit_post_trial' */
                'tax_rate' => 'DECIMAL(3, 3) UNSIGNED NOT NULL DEFAULT 0', /* 'tax_rate' */
                'paypal_email' => 'VARCHAR(255) DEFAULT \'\'', /* 'paypal_email' */
                'notification_day' => 'TINYINT(3) UNSIGNED NOT NULL DEFAULT 0', /* 'notification_day' */
                'required_group_ids' => 'VARBINARY(255) NOT NULL DEFAULT \'\'', /* 'required_group_ids' */
                'permanent_group_ids' => 'VARBINARY(255) NOT NULL DEFAULT \'\'', /* 'permanent_group_ids' */
                'upgrade_category_id' => 'INT(10) UNSIGNED NOT NULL DEFAULT 0', /* END 'upgrade_category_id' */
            ), /* END 'xf_user_upgrade' */
        );
    } /* END _getTableChanges */

    /**
     *
     * @see Waindigo_Install::_getEnumValues()
     */
    protected function _getEnumValues()
    {
        return array(
            'xf_user' => array(
                'user_state' => array(
                    'add' => array(
                        'paypal_pending'
                    ), /* END 'add' */
                ), /* END 'user_state' */
            ), /* END 'xf_user' */
        );
    } /* END _getEnumValues */

    protected function _getContentTypes()
    {
        return array(
            'user_upgrade' => array(
                'addon_id' => 'Waindigo_UserUpgrades', /* END 'addon_id' */
                'fields' => array(
                    'alert_handler_class' => 'Waindigo_UserUpgrades_AlertHandler_UserUpgrade'
                ) /* END 'fields' */
            )
        );
    } /* END _getContentTypes */

    /**
     * @see Waindigo_Install::_postInstall()
     */
    protected function _postInstall()
    {
        $hiddenKey = XenForo_Application::getSimpleCacheData(self::WAINDIGO_USERUPGRADES_HIDDENKEY);

        if (!$hiddenKey) {
            $hiddenKey = XenForo_Application::generateRandomString(10);
            XenForo_Application::setSimpleCacheData(self::WAINDIGO_USERUPGRADES_HIDDENKEY, $hiddenKey);
        }

    } /* END _postInstall */
}