<?php

class Waindigo_UserUpgrades_Listener_TemplateCreate extends Waindigo_Listener_TemplateCreate
{

    protected function _getTemplates()
    {
        return array(
            'account_upgrades',
            'account_wrapper',
            'user_upgrade_active',
            'user_upgrade_edit',
            'user_upgrade_list',
            'user_edit',
            'user_search',
            'register_process'
        );
    } /* END _getTemplates */

    public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
    {
        $templateCreate = new Waindigo_UserUpgrades_Listener_TemplateCreate($templateName, $params, $template);
        list ($templateName, $params) = $templateCreate->run();
    } /* END templateCreate */

    protected function _accountUpgrades()
    {
        $this->_templateName = 'waindigo_account_upgrades_userupgrades';
    } /* END _accountUpgrades */

    protected function _accountWrapper()
    {
        $this->_preloadTemplate('waindigo_account_alerts_extra_userupgrades');;
    } /* END _accountWrapper */ /* END _accountUpgrades */
    
    protected function _userUpgradeActive()
    {
        $this->_templateName = 'waindigo_user_upgrade_active_userupgrades';
    } /* END _userUpgradeActive */

    protected function _userUpgradeEdit()
    {
        $this->_templateName = 'waindigo_user_upgrade_edit_userupgrades';
    } /* END _userUpgradeEdit */

    protected function _userUpgradeList()
    {
        $this->_preloadTemplate('waindigo_topctrl_userupgrades');
    } /* END _userUpgradeList */
    
    protected function _userEdit()
    {
        $this->_preloadTemplate('waindigo_user_edit_userupgrades');
    } /* END _userEdit */
    
    protected function _userSearch()
    {
        $this->_preloadTemplate('waindigo_user_search_userupgrades');
    } /* END _userSearch */

    protected function _registerProcess()
    {
        $this->_preloadTemplate('waindigo_register_process_userupgrades');
    } /* END _registerProcess */
}