<?php

class Waindigo_UserUpgrades_Listener_TemplatePostRender extends Waindigo_Listener_TemplatePostRender
{

    protected function _getTemplates()
    {
        return array(
            'user_upgrade_list',
            'user_edit',
            'user_search',
            'notice_edit',
            'register_process',
            'user_batch_update_search',
            'sidenav_entry'
        );
    } /* END _getTemplates */

    public static function templatePostRender($templateName, &$content, array &$containerData,
        XenForo_Template_Abstract $template)
    {
        $templatePostRender = new Waindigo_UserUpgrades_Listener_TemplatePostRender($templateName, $content,
            $containerData, $template);
        list ($content, $containerData) = $templatePostRender->run();
    } /* END templatePostRender */

    protected function _userUpgradeList()
    {
        $viewParams = $this->_fetchViewParams();
        $this->_appendTemplate('waindigo_topctrl_userupgrades', $viewParams, $this->_containerData['topctrl']);
    } /* END _userUpgradeList */

    protected function _userEdit()
    {
        $pattern = '#(<select name="user_state" class="textCtrl" id="ctrl_user_state">.*)(</select>)#Us';
        $replacement = '${1}' . $this->_escapeDollars($this->_render('waindigo_user_edit_userupgrades')) . '${2}';
        $this->_patternReplace($pattern, $replacement);
    } /* END _userEdit */

    protected function _noticeEdit()
    {
        $pattern = '#(<select name="user_criteria[user_state][data][state]" class="textCtrl autoSize disabled" id="ctrl_user_criteriauser_statedatastate" disabled="">.*)(</select>)#Us';
        $replacement = '${1}' . $this->_escapeDollars($this->_render('waindigo_user_edit_userupgrades')) . '${2}';
        $this->_patternReplace($pattern, $replacement);
    } /* END _noticeEdit */

    protected function _userSearch()
    {
        $pattern = '#(<li><label for="ctrl_criteriauser_state_moderated">.*)(</li>)#Us';
        $this->_appendTemplateAtPattern($pattern, 'waindigo_user_search_userupgrades');
    } /* END _userSearch */

    protected function _userBatchUpdateSearch()
    {
        $this->_userSearch();
    } /* END _userBatchUpdateSearch */

    protected function _registerProcess()
    {
        $viewParams = $this->_fetchViewParams();
        if ($viewParams['user']['user_state'] == 'paypal_pending') {
            $pattern = '#(<div class="systemMessage">).*(<div class="baseHtml">)#Us';
            $replacement = '${1}' . $this->_escapeDollars($this->_render('waindigo_register_process_userupgrades')) .
                 '${2}';
            $this->_patternReplace($pattern, $replacement);
        }
    } /* END _registerProcess */

    protected function _sideNavEntry()
    {
        if (XenForo_Application::getOptions()->currentVersionId >= 1030000) {
            $pattern = '#(<li class="sideNavLink">\s*<a href="admin.php\?advanced-upgrades/log">).*(</li>)#Us';
            $replacement = '';
            $this->_patternReplace($pattern, $replacement);
        }
    } /* END _sideNavEntry */
}