<?php

class WhoHasVisited_Listener
{
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		if ($hookName == 'forum_list_sidebar')
		{
			$whoHasVisitedModel = XenForo_Model::create('WhoHasVisited_Model_WhoVisited');
			
			if ($whoHasVisitedModel->canViewWhoVisited())
			{
				$params = $template->getParams();
				$params += $hookParams;
				
				$params['hours'] = XenForo_Application::get('options')->whoHasVisitedHours;
							
				$whoHasVisited = $whoHasVisitedModel->getWhoVisitedFromCache();
				$whoHasVisited = $whoHasVisitedModel->prepareWhoHasVisited($whoHasVisited);
				
				$params['whoHasVisited'] = !empty($whoHasVisited['users']) ? $whoHasVisited : array();
				
				$marker = '<!-- end block: sidebar_online_users -->';
				$whoVisited = $template->create('forum_list_who_visited_wrapper', $params);
				
				$contents = preg_replace("#$marker#", "$0$whoVisited", $contents);
			}
		}
	}
	
	public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		if ($templateName == 'online_list')
		{
			$whoHasVisitedModel = XenForo_Model::create('WhoHasVisited_Model_WhoVisited');
			
			if ($whoHasVisitedModel->canViewWhoVisited())
			{			
				$params = $template->getParams();

				$params['hours'] = XenForo_Application::get('options')->whoHasVisitedHours;
				
				$whoHasVisited = $whoHasVisitedModel->getWhoVisitedFromCache();
				$whoHasVisited = $whoHasVisitedModel->prepareWhoHasVisited($whoHasVisited);
				
				$params['whoHasVisited'] = !empty($whoHasVisited['users']) ? $whoHasVisited : array();				
				
				$whoVisited = $template->create('forum_list_who_visited_wrapper', $params);
				
				$containerData['sidebar'] = $containerData['sidebar'] . $whoVisited;
			}
		}
	}
	
	public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template)
	{
		if ($templateName == 'forum_list' || $templateName == 'online_list')
		{
			$template->create('forum_list_who_visited_wrapper');
		}
	}
	
	public static function extendWidgetRenderers(array &$renderers)
	{
		$renderers[] = 'WhoHasVisited_WidgetRenderer_WhoHasVisited';
	}
}
