<?php

class WhoHasVisited_Model_WhoVisited extends XenForo_Model
{
	public function updateWhoVisitedCache()
	{
		$whoVisited = $this->getWhoVisited();
		
		XenForo_Application::setSimpleCacheData('whoHasVisited', $whoVisited);
		
		return $whoVisited;
	}
	
	public function getWhoVisited()
	{
		$timeRange = $this->getTimeRange();
		
		$options = XenForo_Application::get('options');
		
		if ($options->WhoHasVisted24Sort == 'WhoHas24Activity')
		{
			$order = 'last_activity DESC';
		}
		else
		{
			$order = 'username ASC';
		}
					
		$users = $this->fetchAllKeyed("
			SELECT
				user.user_id, user.username,
				user.avatar_date, user.last_activity,
				user.visible, user.is_banned,
				user.display_style_group_id, activity.view_date
			FROM xf_user AS user
			LEFT JOIN xf_session_activity AS activity ON
				(user.user_id = activity.user_id)
			WHERE last_activity BETWEEN
				$timeRange[from] AND $timeRange[to]
			ORDER BY $order
		", 'user_id');
		
		$whoHasVisited = array(
			'time' => XenForo_Application::$time,
			'users' => $users,
		);
		
		foreach ($whoHasVisited['users'] AS &$user)
		{
			$user['last_activity'] = $user['view_date'] > $user['last_activity'] ? $user['view_date'] : $user['last_activity'];
		}
		
		return $whoHasVisited;
	}
				
	public function getWhoVisitedFromCache()
	{
		$options = XenForo_Application::get('options');
		$currentTime = XenForo_Application::$time;
		
		if ($options->whoHasVisitedCached)
		{
			$whoHasVisited = XenForo_Application::getSimpleCacheData('whoHasVisited');
			
			if (empty($whoHasVisited))
			{
				return $this->updateWhoVisitedCache();
			}
			
			if (!empty($whoHasVisited['time']) && ($currentTime - $whoHasVisited['time']) <= ($options->whoHasVisitedCached * 60))
			{
				return $whoHasVisited;
			}
			
			return $this->updateWhoVisitedCache();
		}
		
		return $this->getWhoVisited();
	}	
	
	public function getTimeRange()
	{
		$options = XenForo_Application::get('options');
		
		$timeRange = array(
			'to' => XenForo_Application::$time,
			'from' => XenForo_Application::$time - ($options->whoHasVisitedHours * 60 * 60)
		);
		
		return $timeRange;
	}
	
	public function prepareWhoHasVisited(array $whoHasVisited)
	{
		foreach ($whoHasVisited['users'] AS $key => &$user)
		{
			if (!$this->getModelFromCache('XenForo_Model_User')->canBypassUserPrivacy())
			{
				if (!$user['visible'])
				{
					unset($whoHasVisited['users'][$key]);
				}
				
				if ($user['is_banned'])
				{
					unset($whoHasVisited['users'][$key]);
				}					
			}
		}
		
		$options = XenForo_Application::get('options');
		
		$whoHasVisited['count'] = count($whoHasVisited['users']);
		
		$whoHasVisited['display_users'] = array_slice($whoHasVisited['users'], 0, $options->whoHasVisitedLimit, true);
		$whoHasVisited['display_count'] = count($whoHasVisited['display_users']);
		
		$whoHasVisited['hide_users'] = array_slice($whoHasVisited['users'], $options->whoHasVisitedLimit, NULL, true);
		$whoHasVisited['hide_count'] = count($whoHasVisited['hide_users']);

		if ($options->whoHasVisited24MostOnline)
		{
			$whoHasVisited['most_online_24'] = XenForo_Model::create('XenForo_Model_DataRegistry')->get('mostOnline24');
				
			if ($whoHasVisited['most_online_24'] < $whoHasVisited['count'])
			{
				$whoHasVisited['most_online_24'] = $whoHasVisited['count'];

				XenForo_Model::create('XenForo_Model_DataRegistry')->set('mostOnline24', $whoHasVisited['most_online_24']);
			}
		}
		
		return $whoHasVisited;
	}
	
	public function canViewWhoVisited(array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
		
		$userGroups = XenForo_Application::get('options')->whoHasVisitedGroup;
		
		return $this->getModelFromCache('XenForo_Model_User')->isMemberOfUserGroup($viewingUser, $userGroups);
	}
}
