<?php

class WhoHasVisited_WidgetRenderer_WhoHasVisited extends WidgetFramework_WidgetRenderer
{
	protected function _getConfiguration()
	{
		return array(
			'name' => 'Who Has Visited',
			'options' => array(
				'limit' => XenForo_Input::UINT,
			),
			'useCache' => false,
		);
	}
	
	protected function _getOptionsTemplate()
	{
		return '';
	}
	
	protected function _validateOptionValue($optionKey, &$optionValue)
	{
		if ('limit' == $optionKey)
		{
			if (empty($optionValue)) $optionValue = 0;
		}
		
		return true;
	}
	
	protected function _getRenderTemplate(array $widget, $positionCode, array $params)
	{
		return 'who_visited_block';
	}
	
	protected function _render(array $widget, $positionCode, array $params, XenForo_Template_Abstract $renderTemplateObject)
	{	
		$whoHasVisitedModel = XenForo_Model::create('WhoHasVisited_Model_WhoVisited');
		
		if ($whoHasVisitedModel->canViewWhoVisited())
		{
			$whoHasVisited = $whoHasVisitedModel->getWhoVisitedFromCache();
			$whoHasVisited = $whoHasVisitedModel->prepareWhoHasVisited($whoHasVisited);
			
			$whoHasVisited = !empty($whoHasVisited['users']) ? $whoHasVisited : array();
			
			$hours = XenForo_Application::get('options')->whoHasVisitedHours;
			
			$renderTemplateObject->setParam('hours', $hours);
			$renderTemplateObject->setParam('whoHasVisited', $whoHasVisited);
			
			return $renderTemplateObject->render();			
		}
	}
}