<?php
class XenMods_MultiPrefix_ControllerPublic_Forum extends XFCP_XenMods_MultiPrefix_ControllerPublic_Forum
{
    function actionAddThread()
    {
        $threadId = 0;

        $prefixId = $this->_input->filterSingle('prefix_id', XenForo_Input::ARRAY_SIMPLE);

        if (!empty($prefixId))
        {
            $this->_request->setParam('prefix_id', $prefixId[0]);
        }
        else
        {
            return parent::actionAddThread();
        }

        $prefixId = implode(',', $prefixId);

        $parent = parent::actionAddThread();
        if (empty($prefixId))
            return $parent;

        if ($parent instanceof XenForo_ControllerResponse_Redirect)
        {
            if (stristr($parent->redirectTarget, '.'))
            {
                $redirectTargetSplice = explode('.', $parent->redirectTarget);
                $threadId = (int) end($redirectTargetSplice);
            }
            else
            {
                $redirectTargetSplice = explode('/', $parent->redirectTarget);
                foreach ($redirectTargetSplice as $possibleId)
                {
                    if (is_numeric($possibleId))
                        $threadId = (int) $possibleId;
                }
            }
        }
        else
        {
            $threadId = $parent->params['thread']['thread_id'];
        }

        if ($threadId > 0)
        {
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
            $dw->setExistingData($threadId);
            $dw->set('prefix_id', $prefixId);
            $dw->save();
        }

        return $parent;
    }
}
