<?php
class XenMods_MultiPrefix_ControllerPublic_Thread extends XFCP_XenMods_MultiPrefix_ControllerPublic_Thread
{
    public function actionMove()
    {
        if ($this->isConfirmedPost()) // move the thread
        {
            return parent::actionMove();
        }
        $threadId = 0;
        $prefixId = $this->_input->filterSingle('prefix_id', XenForo_Input::ARRAY_SIMPLE);
        if (!empty($prefixId))
        {
            $this->_request->setParam('prefix_id', $prefixId[0]);
        }
        else
        {
            return parent::actionMove();
        }

        $prefixId = implode(',', $prefixId);

        $parent = parent::actionMove();

        if ($parent instanceof XenForo_ControllerResponse_Redirect)
        {
            if (stristr($parent->redirectTarget,'.'))
            {
                $redirectTargetSplice = explode('.', $parent->redirectTarget);
                $threadId = (int) end($redirectTargetSplice);
            }
            else
            {
                $redirectTargetSplice = explode('/', $parent->redirectTarget);
                foreach ($redirectTargetSplice as $possibleId)
                {
                    if (is_numeric($possibleId))
                    {
                        $threadId = (int) $possibleId;
                    }
                }
            }
            if ($threadId > 0)
            {
                $dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
                $dw->setExistingData($threadId);
                $dw->set('prefix_id', $prefixId);
                $dw->save();
            }
        }
        return $parent;


    }
    public function actionSave()
    {
        $threadId = 0;

        $prefixId = $this->_input->filterSingle('prefix_id', XenForo_Input::ARRAY_SIMPLE);
        if (!empty($prefixId))
        {
            $this->_request->setParam('prefix_id', $prefixId[0]);
        }
        else
        {
            return parent::actionSave();
        }
        $prefixId = implode(',', $prefixId);

        $parent = parent::actionSave();

        if ($parent instanceof XenForo_ControllerResponse_Redirect)
        {
            if (stristr($parent->redirectTarget,'.'))
            {
                $redirectTargetSplice = explode('.', $parent->redirectTarget);
                $threadId = (int) end($redirectTargetSplice);
            }
            else
            {
                $redirectTargetSplice = explode('/', $parent->redirectTarget);
                foreach ($redirectTargetSplice as $possibleId)
                {
                    if (is_numeric($possibleId))
                    {
                        $threadId = (int) $possibleId;
                    }
                }
            }
        }
        else
        {
            $threadId = $parent->params['thread']['thread_id'];
        }

        if ($threadId > 0)
        {
            $dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
            $dw->setExistingData($threadId);
            $dw->set('prefix_id', $prefixId);
            $dw->save();
        }

        return $parent;
    }
}