<?php
    class XenMods_MultiPrefix_Model_Thread extends XFCP_XenMods_MultiPrefix_Model_Thread
    {
        public function prepareThreadConditions(array $conditions, array &$fetchOptions)
        {            
            if (!empty($conditions['prefix_id']))
            {
                $newConditions = $conditions;
                unset($newConditions['prefix_id']);
                $sqlConditions = array();
                $sqlConditions[] = 'FIND_IN_SET(' . $this->_getDb()->quote($conditions['prefix_id']) . ', thread.prefix_id)';
                
                $defaultReturn = parent::prepareThreadConditions($newConditions, $fetchOptions);
                return (!empty($defaultReturn)) ? $this->getConditionsForClause($sqlConditions) . ' and ' . $defaultReturn : $this->getConditionsForClause($sqlConditions);
            }
            
            return parent::prepareThreadConditions($conditions, $fetchOptions);
        }
    }