<?php

class XfAddOns_LinkEssentials_BBCode_Formatter extends XFCP_XfAddOns_LinkEssentials_BBCode_Formatter
{

	/**
	 * @var XfAddOns_LinkEssentials_Util_UrlParser
	 */
	private $urlParser;
	
	/**
	 * Constructor. Initializes variables used by this class
	 */
	public function __construct()
	{
		parent::__construct();
		$this->urlParser = new XfAddOns_LinkEssentials_Util_UrlParser();
	}
	
	/**
	 * 
	 * 
	 * @param array $tag
	 * @param array $rendererStates
	 */
	public function renderTagUrl(array $tag, array $rendererStates)
	{
		// Retrieve the URL so we can add a favicon
		$usingInterstitial = false;
		if (!empty($tag['option']))
		{
			$url = $tag['option'];
			if ($this->useInterstitial($url))
			{
				$extraParams['url'] = $url;
				$interstitial = XenForo_Link::buildPublicLink('full:xfa-interstitial/redirect', null, $extraParams);
				$tag['option'] = $interstitial;
				$usingInterstitial = true;
			}
		}
		else
		{
			$url = $this->stringifyTree($tag['children']);
			if ($this->useInterstitial($url))
			{
				$extraParams['url'] = $url;
				$interstitial = XenForo_Link::buildPublicLink('full:xfa-interstitial/redirect', null, $extraParams);
				$tag['option'] = $interstitial;
				$tag['children'] = array ( $url );
				$usingInterstitial = true;
			}
		}
		
		// parse the url
		$html = parent::renderTagUrl($tag, $rendererStates);
		if (empty($html))
		{
			return $html;
		}

		$options = XenForo_Application::getOptions();
		if ($options->xfa_le_link_preview && XfAddOns_LinkEssentials_Preview_Util::isPreviewExists($url))
		{
			$extraParams = array( 'url' => $url);
			$previewUrl = XenForo_Link::buildPublicLink('xfa-snapshot', null, $extraParams);
			$html = preg_replace(
					'#class="(.*)"#isU',
					"class=\"$1 PreviewTooltip\" data-previewurl=\"{$previewUrl}\"",
					$html);
		}
		if ($usingInterstitial)
		{
			$html = preg_replace(
					'#<a([^>]+)>#isU',
					"<a $1 target=\"_blank\">",
					$html);
		}

		// add a favicon if the linked data in the URL is NOT complex
		if ($options->xfa_le_favicon && (empty($tag['children']) || is_string($tag['children'][0])))
		{
			$domain = $this->urlParser->getDomain($url);
			if (!empty($domain))
			{
				$favicon = "//www.google.com/s2/favicons?domain=" . urlencode($domain);
				$html = "<div class=\"link-essentials-favicon\">
				<img src=\"$favicon\" width=\"16\" height=\"16\" class=\"favicon\" />
				" . $html . "</div>";
			}
		}
		
		return $html;
	}
	
	/**
	 * Returns the configured whitelist of links that never use the interstitial
	 * @return Ambigous <string, unknown, mixed>
	 */
	private function getWhileList()
	{
		$options = XenForo_Application::getOptions();
		$whitelist = preg_split("#[\r\n]+#", $options->xfa_le_whitelist);
		$whitelist[] = $_SERVER['HTTP_HOST'];
		
		// depending on how we access the page, add to the whitelist the www, or don't add it
		if (strpos($_SERVER['HTTP_HOST'], 'www.') === false)
		{
			$whitelist[] = 'www.' . $_SERVER['HTTP_HOST'];
		}
		else
		{
			$whitelist[] = str_replace("www.", "", $_SERVER['HTTP_HOST']);
		}
		return $whitelist;		
	}
	
	/**
	 * Check if we need to use a interstitial link for the page. 
	 * @param String $url	The URL being rendered
	 * @return boolean	true, if an interstitial should be used
	 */
	private function useInterstitial($url)
	{
		$options = XenForo_Application::getOptions();
		if (!$options->xfa_le_interstitial)
		{
			return false;
		}
		
		$data = parse_url($url);
		// A malformed URL, e.g., no protocol
		if (empty($data) || empty($data['host']))
		{
			return true;
		}

		$whitelist = $this->getWhileList();
		return !in_array($data['host'], $whitelist);
	}
	
	
	
}