<?php 

/**
 * Controller for the interstitial page that is shown before dispatching the user
 * to the link
 */
class XfAddOns_LinkEssentials_ControllerPublic_Interstitial extends XenForo_ControllerPublic_Abstract
{
	
	/**
	 * Display an interstitial page, that will redirect the user to the location
	 * in the URL parameter
	 */
	public function actionRedirect()
	{
		$options = XenForo_Application::getOptions();
		$url = $this->_input->filterSingle('url', XenForo_Input::STRING);
		$params = array(
			'url' => $url,
			'seconds' => $options->xfa_le_redirect_seconds
		);
		return $this->responseView('XenForo_ViewPublic_Index', 'xfa_link_interstitial', $params);
	}
	
}