<?php

/**
 * Cron job that handles the cleanup of old previous so they don't fill up the disk
 */
class XfAddOns_LinkEssentials_Cron_CleanOldPreviews
{
	
	/**
	 * The amount of days that the files are kept in the filesystem
	 * @var int
	 */
	private $days = -1;
	
	/**
	 * The max timestamp that the files are kept in the filesystem
	 * @var int
	 */
	private $maxAge = -1;
	
	/**
	 * Constructor. Initializes the maxAge for deleting files.
	 */
	public function __construct()
	{
		$options = XenForo_Application::getOptions();
		$this->days = $options->xfa_le_store_days;
		if ($this->days > 0)
		{
			$this->maxAge = XenForo_Application::$time - ($this->days * 86400);
		}
	}
	
	/**
	 * Runs the Cron Job
	 */
	public static function run()
	{
		$cron = new XfAddOns_LinkEssentials_Cron_CleanOldPreviews();
		$cron->cleanup();
	}
	
	/**
	 * Run the cleanup process on the previews directory
	 */
	public function cleanup()
	{
		if (!XfAddOns_LinkEssentials_Listener::isAdvancedFeatures())
		{
			XfAddOns_LinkEssentials_Log::warn("Cleanup disabled because this is not the paid version");
			return;
		}
		
		$options = XenForo_Application::getOptions();
		$previewsDir = $options->xfa_le_previews_dir;
		if (!is_dir($previewsDir))
		{
			XfAddOns_LinkEssentials_Log::info("Tried to run the previews cleanup job, but the directory is invalid");
			return;
		}
		if ($this->maxAge <= 0)
		{
			XfAddOns_LinkEssentials_Log::debug("Cleanup will not run because it is disabled by config");
			return;
		}
		
		$handle = opendir($previewsDir);
		while (($file = readdir($handle)) !== false)
		{
			if ($file == '.' || $file == '..')
			{
				continue;
			}
			
			$path = $previewsDir . '/' . $file;
			$this->checkFileExpires($path);
		}
		closedir($handle);
	}
	
	/**
	 * Check if a file has expired, and if so unlink it
	 */
	protected function checkFileExpires($image)
	{
		if (!is_file($image))
		{
			return;
		}
		
		$fileTime = filemtime($image);
		$timeStr = date("d-M-Y h:i:s", $fileTime);
		if ($fileTime < $this->maxAge)
		{
			@unlink($image);
			XfAddOns_LinkEssentials_Log::info("Deleting the file {$image} since it is more than {$this->days} days old: {$timeStr}");
		}
		else
		{
			XfAddOns_LinkEssentials_Log::debug("The file {$image} is preserved since it is less than {$this->days} days old: {$timeStr}");
		}
	}
	
	
	
}