<?php

/**
 * Check if the post has URLs, if so, generate an image preview for the site 
 */
class XfAddOns_LinkEssentials_Deferred_GeneratePreview extends XenForo_Deferred_Abstract
{
	
	/**
	 * @var XfAddOns_LinkEssentials_Util_ImageParser
	 */
	private $imageParser;
	
	public function __construct()
	{
		parent::__construct();
		$this->imageParser = new XfAddOns_LinkEssentials_Util_ImageParser();
	}
	
	/**
	 * This will fetch the information on a post. If the post contains any Urls, it will
	 * attempt to parse them and update them with the title of the page
	 */
	public function execute(array $deferred, array $data, $targetRunTime, &$status)
	{
		$postId = $data['post_id'];
		XfAddOns_LinkEssentials_Log::log("Running GeneratePreview deferred task for " . $postId);
		
		/* @var $postModel XenForo_Model_Post */
		$postModel = XenForo_Model::create('XenForo_Model_Post');
		$post = $postModel->getPostById($postId);
		if (empty($post))
		{
			return;
		}
		$this->imageParser->generatePreviews($post['message'], $data);
	}
	
}
