<?php

/**
 * This deferred task will take a Wordpress URL and generate a preview 
 */
class XfAddOns_LinkEssentials_Deferred_Page2Images extends XenForo_Deferred_Abstract
{
	
	/**
	 * In $data we must have a url, that we will attempt to fetch using the Wordpress Snapshot service
	 */
	public function execute(array $deferred, array $data, $targetRunTime, &$status)
	{
		$url = $data['url'];
		if (empty($url))
		{
			XfAddOns_LinkEssentials_Log::log("Page2Images preview deferred task got an empty URL");
			return;
		}

		$w = new XfAddOns_LinkEssentials_Preview_Page2Images($url, $data);
		$w->saveImageForUrl();
	}
	
}
