<?php

/**
 * Check if the post has URLs, if so, update the content of the post with the page title 
 */
class XfAddOns_LinkEssentials_Deferred_UpdatePost extends XenForo_Deferred_Abstract
{
	
	/**
	 * @var XfAddOns_LinkEssentials_Util_UrlParser
	 */
	private $urlParser;
	
	public function __construct()
	{
		parent::__construct();
		$this->urlParser = new XfAddOns_LinkEssentials_Util_UrlParser();
	}
	
	/**
	 * This will fetch the information on a post. If the post contains any Urls, it will
	 * attempt to parse them and update them with the title of the page
	 */
	public function execute(array $deferred, array $data, $targetRunTime, &$status)
	{
		$postId = $data['post_id'];
		XfAddOns_LinkEssentials_Log::log("Running deferred task for " . $postId);
		
		/* @var $postModel XenForo_Model_Post */
		$postModel = XenForo_Model::create('XenForo_Model_Post');
		$post = $postModel->getPostById($postId);
		
		$logMsg = XfAddOns_LinkEssentials_Log::decorate($post['message']); 
		XfAddOns_LinkEssentials_Log::debug($logMsg);
		
		if (empty($post))
		{
			return;
		}
		$newMessage = $this->urlParser->substituteUrls($post['message']);
		
		if (!empty($newMessage) && $newMessage != $post['message'])
		{
			XfAddOns_LinkEssentials_Log::log("Replacing message in post: " . $postId);
			
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
			$dw->setExistingData($post);
			$dw->setExtraData('ignoreAdvancedLink', true);
			$dw->set('message', $newMessage);
			$dw->save();
		}
	}
	
}
