<?php

/**
 * This deferred task will take a Wordpress URL and generate a preview 
 */
class XfAddOns_LinkEssentials_Deferred_Wordpress extends XenForo_Deferred_Abstract
{
	
	/**
	 * In $data we must have a url, that we will attempt to fetch using the Wordpress Snapshot service
	 */
	public function execute(array $deferred, array $data, $targetRunTime, &$status)
	{
		$url = $data['url'];
		if (empty($url))
		{
			XfAddOns_LinkEssentials_Log::log("Wordpress preview deferred task got an empty URL");
			return;
		}

		$w = new XfAddOns_LinkEssentials_Preview_Wordpress($url, $data);
		$w->saveImageForUrl();
	}
	
}
