<?php

/**
 * An external resource, that can be either a page, or an image 
 */
class XfAddOns_LinkEssentials_ExternalResource
{

	/**
	 * The URL that we linked to
	 * @var string
	 */
	public $url;
	
	/**
	 * true, if it is a page, false otherwise
	 * @var boolean
	 */
	public $isPage;	
	
	/**
	 * true, if it is an image, false otherwise
	 * @var boolean
	 */
	public $isImage;
	
	/**
	 * The whole page content, only if the page is HTML
	 * @var string
	 */
	public $pageContent;
	
	/**
	 * If present, the location for the favIcon
	 * @var string
	 */
	public $favIcon;
	
	/**
	 * This method extracts the page content, and normalizes the title
	 */
	public function getTitle()
	{
		$title = $this->extractTitleFromPageContent();
		if (empty($title))
		{
			return $title;
		}

		// decode html entities
		$title = html_entity_decode($title);
		
		// check for internal links, and remove the title
		$options = XenForo_Application::getOptions();
		XfAddOns_LinkEssentials_Log::log("Looking to see if " . $this->url . " is an internal link and contains: " . $options->boardUrl);
		if (preg_match('#' . preg_quote($options->boardUrl, '#') . '#i', $this->url))
		{
			XfAddOns_LinkEssentials_Log::log("Matched an internal url");
			$title = preg_replace('#' . preg_quote($options->boardTitle, '#')  . '#', '', $title);
			$title = preg_replace('#\s*\|\s*$#', '', $title);
		}		
		
		// check for length
		$options = XenForo_Application::getOptions();
		if (count($title) > $options->xfa_le_max_title_length)
		{
			$title = substr($title, 0, $options->xfa_le_max_title_length);
		}
		return $title;	
	}
	
	/**
	 * This method will extract the title from the Page Content, if there is content available
	 * @return string
	 */	
	private function extractTitleFromPageContent()
	{
		if (empty($this->pageContent))
		{
			return '';
		}
		
		// try to find the title HTML tag
		$matches = array();
		preg_match('#<title>(.*)</title>#isU', $this->pageContent, $matches);
		if (!empty($matches[1]))
		{
			$title = trim($matches[1]);
			if (!empty($title))
			{
				return $title;
			}
		}
		
		// if failed, try with the H1 tag
		$matches = array();
		preg_match('#<H1>(.*)</H1>#iU', $this->pageContent, $matches);
		if (!empty($matches[1]))
		{
			$title = trim($matches[1]);
			if (!empty($title))
			{
				return $title;
			}
		}
		return '';		
	}
	
	
}
