<?php

/**
 * Enable extensions
 */
class XfAddOns_LinkEssentials_Listener
{
	
	/**
	 * Extends datawriter
	 */
	public static function listenDataWriter($class, array &$extend)
	{
		if ($class == 'XenForo_DataWriter_DiscussionMessage_Post')
		{
			$extend[] = 'XfAddOns_LinkEssentials_Override_DataWriter_Post';
		}
	}
	
	/**
	 * Extend with a new BBCode for the favicon
	 */
	public static function listenBbCode($class, array &$extend)
	{
		if ($class == 'XenForo_BbCode_Formatter_Base')
		{
			$extend[] = 'XfAddOns_LinkEssentials_BBCode_Formatter';
		}
	}
	
	/**
	 * Add the CSS to all pages, since a link can be anywhere
	 */
	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		$template->addRequiredExternal('css', 'xfa_link_essentials');
	}
	
	/**
	 * Check if the advanced features should be activated
	 * @return boolean
	 */	
	public static function isAdvancedFeatures()
	{
		return XfAddOns_LinkEssentials_Install_Version::$isFreeVersion === '0' ||
				XfAddOns_LinkEssentials_Install_Version::$isFreeVersion === '__IS_FREE__';
	}
	
}


// This is used in the template modifier to use the copyright
$GLOBALS['xfa_copyright'] = !XfAddOns_LinkEssentials_Listener::isAdvancedFeatures();




