<?php 

/**
 * Extends XenForo_DataWriter_DiscussionMessage_Post
 */
class XfAddOns_LinkEssentials_Override_DataWriter_Post extends XFCP_XfAddOns_LinkEssentials_Override_DataWriter_Post
{

	/**
	 * After the post is committed, we add a deferred task to evaluate
	 * for URLs
	 */
	protected function _postSaveAfterTransaction()
	{
		// Through a deferred task, update the URLS
		try
		{
			$this->addLinkDeferredTask();
		}
		catch (Exception $ex)
		{
			XfAddOns_LinkEssentials_Log::log($ex->getMessage());
			XenForo_Error::logException($ex, false);
		}
		
		return parent::_postSaveAfterTransaction();
	}	
	
	/**
	 * If the post is new or changed, we will need to reparse the URLs
	 */
	private function addLinkDeferredTask()
	{
		if (!$this->isChanged('message'))
		{
			return;
		}
		if ($this->getExtraData('ignoreAdvancedLink') == true)
		{
			return;
		}
				
		$xenOptions = XenForo_Application::getOptions();
		
		$postId = $this->get('post_id');
		/* @var $deferred XenForo_Model_Deferred */
		$deferred = XenForo_Model::create('XenForo_Model_Deferred');
		$options = array(
			'post_id' => $postId
		);
		
		// Convert the title links
		if ($xenOptions->xfa_le_fetch_link)
		{
			$taskKey = 'xfa_le_' . $postId;
			$deferred->defer('XfAddOns_LinkEssentials_Deferred_UpdatePost', $options, $taskKey);
		}

		// Generate the image previews
		if ($xenOptions->xfa_le_link_preview)
		{
			$taskKey = 'xfa_lep_' . $postId;
			$deferred->defer('XfAddOns_LinkEssentials_Deferred_GeneratePreview', $options, $taskKey);
		}
	}
	
	
}