<?php

/**
 * Generation of the screenshot through the Page2Images service
 */
class XfAddOns_LinkEssentials_Preview_Page2Images extends XfAddOns_LinkEssentials_Preview_Preview
{
	
	/**
	 * Return the URL for the remote service that will be used to retrieve the URL
	 * @return string
	 */
	private function getServiceUrl()
	{
		$options = XenForo_Application::getOptions();
		$width = $options->xfa_le_width;
		$height = 384;
		
		$remoteUrl = "http://api.page2images.com/restfullink?";
		$remoteUrl .= "&p2i_device=6";
		$remoteUrl .= "&p2i_screen=1024x768";
		$remoteUrl .= "&p2i_size={$width}x{$height}";
		$remoteUrl .= "&p2i_imageformat=png&p2i_wait=5";
		$remoteUrl .= "&p2i_key=" . $options->xfa_le_page2images_api;
		$remoteUrl .= "&p2i_url=" . urlencode($this->url);
		return $remoteUrl;
	}
	
	/**
	 * Save a preview for the website in the images directory
	 *
	 * @param string $url	The URL to save
	 */
	protected function _saveImageForUrl()
	{
		$serviceUrl = $this->getServiceUrl();
		/* @var $response Zend_Http_Response */
		$client = self::getClient($serviceUrl);
		$response = $client->setHeaders('Accept-encoding', 'identity')->request('GET');
		
		$payload = $response->getBody();
		if (empty($payload))
		{
			XfAddOns_LinkEssentials_Log::log("Page2Images: Got empty response on {$serviceUrl}");
			return;
		}
		
		$jsonResponse = json_decode($payload);
		if ($jsonResponse->status == 'finished')
		{
			$client = self::getClient($jsonResponse->image_url);
			$response = $client->setHeaders('Accept-encoding', 'identity')->request('GET');
			XfAddOns_LinkEssentials_Log::log("Page2Images success, saving the image in: " . $this->filePath);
			$payload = $response->getBody();
			file_put_contents($this->filePath, $payload);
			return;			
		}
		if ($jsonResponse->status == 'processing')
		{
			$delay = $jsonResponse->estimated_need_time;
			$options = array(
				'url' => $this->url,
				'retries' => isset($this->deferredData['retries']) ? $this->deferredData['retries'] + 1 : 1
			);
			/* @var $deferred XenForo_Model_Deferred */
			$deferred = XenForo_Model::create('XenForo_Model_Deferred');
			$deferred->defer('XfAddOns_LinkEssentials_Deferred_Page2Images', $options, null, false, XenForo_Application::$time + $delay);
			XfAddOns_LinkEssentials_Log::log("Page2Images preview processing. Deferred for {$delay} seconds later");
			return;			
		}
		if ($jsonResponse->status == 'error')
		{
			$msg = "Page2Images: Got error on {$serviceUrl}: {$jsonResponse->msg}";
			XfAddOns_LinkEssentials_Log::log($msg);
			XenForo_Error::logException(new Exception($msg), false);
			return;
		}
	}	
		
}