<?php

/**
 * Generation of the screenshot through the Wordpress multishot service
 */
abstract class XfAddOns_LinkEssentials_Preview_Preview
{
	
	/**
	 * The URL that we are asked to fetch
	 * @var string
	 */
	protected $url;
	
	/**
	 * If this was called through the deferred data mechanism, the data that was sent along
	 * @var array
	 */
	protected $deferredData;
	
	/**
	 * Filename for the screenshot preview file
	 * @var string
	 */
	protected $fileName;
	
	/**
	 * Path for the saved screenshot preview 
	 * @var string
	 */
	protected $filePath;
	
	/**
	 * Constructor. Initializes common objects for the url we are going to save
	 * @param unknown $url
	 */
	public function __construct($url, $deferredData)
	{
		$this->url = $url;
		$this->deferredData = $deferredData;
		$this->generateFileNameAndPath();
	}
	
	/**
	 * Generates the fileName that we will save to, and the full directory path
	 */
	private function generateFileNameAndPath()
	{
		$snapshotsDir = $this->getSnapshotsDirectory();
		$this->fileName = base64_encode($this->url) . '.png';
		$this->filePath = $snapshotsDir . '/' . $this->fileName;
	}
	
	/**
	 * Save a snapshot of a URL into the filesystem. If the file already exists it won't be substituted
	 * @param string $url	The remote URL that we are going to fetch
	 */
	public function saveImageForUrl()
	{
		if (is_file($this->filePath))
		{
			XfAddOns_LinkEssentials_Log::log("Preview already exists: " . $this->filePath);
			return;
		}		
		return $this->_saveImageForUrl();
	}
	
	/**
	 * The implementation for saving a snapshot of a URL into the filesystem
	 */
	protected abstract function _saveImageForUrl();
	
	/**
	 * Check that the directory in which we store the previews exist. Create if necessary
	*/
	protected function getSnapshotsDirectory()
	{
		$options = XenForo_Application::getOptions();
		$previewsDir = $options->xfa_le_previews_dir;
		if (!is_dir($previewsDir))
		{
			@mkdir($previewsDir, 0777);
		}
		if (!is_dir($previewsDir))
		{
			throw new Exception('The previews directory is not valid: ' . $previewsDir);
		}
		return $previewsDir;
	}
	
	/**
	 * A custom Zend Client that we configure to NOT use redirections
	 */
	protected static function getClient($uri)
	{
		$options = array(
			'timeout' => 30,
			'maxredirects' => 0
		);		

		if (function_exists('curl_getinfo'))
		{
			$options += array(
				'adapter' => 'Zend_Http_Client_Adapter_Curl',
				'curloptions' => array(
					CURLOPT_SSL_VERIFYPEER => false,
					CURLOPT_FOLLOWLOCATION => false
				)
			);
		}
		return new Zend_Http_Client($uri, $options);
	}
	
	
}