<?php

/**
 * Generation of the screenshot through the Page2Images service
 */
class XfAddOns_LinkEssentials_Preview_WkHtmlToImage extends XfAddOns_LinkEssentials_Preview_Preview
{

	/**
	 * Return the location for the executable used to convert an html page to an image
	 * @return string
	 */
	private function getBinary()
	{
		if (is_executable('/usr/bin/wkhtmltoimage'))
		{
			return '/usr/bin/wkhtmltoimage';
		}
		if (is_executable('/usr/local/bin/wkhtmltoimage'))
		{
			return '/usr/local/bin/wkhtmltoimage';
		}
		if (is_executable('/opt/bin/wkhtmltoimage'))
		{
			return '/opt/bin/wkhtmltoimage';
		}
	
		// check if we can autodetect it
		$output = null;
		exec('which wkhtmltoimage', $output);
		if (!empty($output))
		{
			$binary = $output[0];
			if (is_executable($binary))
			{
				return $binary;
			}
		}
		return null;
	}	
	
	/**
	 * Save a preview for the website in the images directory
	 *
	 * @param string $url	The URL to save
	 */
	protected function _saveImageForUrl()
	{
		$wkhtmltoimage = $this->getBinary();
		if (empty($wkhtmltoimage))
		{
			XenForo_Error::logError("wkhtmltoimage not found in the path");
			XfAddOns_LinkEssentials_Log::log("wkhtmltoimage not found in the path");
			return;
		}
		
		$cmd = "{$wkhtmltoimage} ";
		$cmd .= "--format png ";
		$cmd .= "--height 768 ";
		$cmd .= "--width 1024 ";
		$cmd .= "--crop-h 768 ";
		$cmd .= "--crop-w 1024 ";		
		
		$cmd .= "\"{$this->url}\" ";
		$cmd .= "\"{$this->filePath}\" ";

		XfAddOns_LinkEssentials_Log::log($cmd);
		$output = null;
		exec($cmd, $output);
		
		if (!empty($output))
		{
			XfAddOns_LinkEssentials_Log::log($output);
		}
	}	
		
}