<?php

/**
 * Generation of the screenshot through the Wordpress multishot service
 */
class XfAddOns_LinkEssentials_Preview_Wordpress extends XfAddOns_LinkEssentials_Preview_Preview
{

	/**
	 * Return the URL for the remote service that will be used to retrieve the URL
	 * @return string
	 */
	private function getServiceUrl()
	{
		$options = XenForo_Application::getOptions();
		$width = $options->xfa_le_width;
		$urlEncoded = urlencode($this->url);
		
		return "http://s.wordpress.com/mshots/v1/{$urlEncoded}?w={$width}";
	}
	
	/**
	 * Save a preview for the website in the images directory
	 *
	 * @param string $url	The URL to save
	 */
	protected function _saveImageForUrl()
	{
		$serviceUrl = $this->getServiceUrl();
		/* @var $response Zend_Http_Response */
		$client = self::getClient($serviceUrl);
		$response = $client->setHeaders('Accept-encoding', 'identity')->request('GET');
		
		$retried = isset($deferredData['retried']) ? $deferredData['retried'] : false; 
		if ($response->getStatus() == 307 && !$retried)
		{
			$options = array(
				'url' => $this->url,
				'retried' => true
			);
			/* @var $deferred XenForo_Model_Deferred */
			$deferred = XenForo_Model::create('XenForo_Model_Deferred');
			// got a temporary image, try again in 2 minutes
			$deferred->defer('XfAddOns_LinkEssentials_Deferred_Wordpress', $options, null, false, XenForo_Application::$time + 120);

			XfAddOns_LinkEssentials_Log::log("Preview not generated, got a redirect. Deferred for 2 minutes later");
			return;
		}
		if ($response->getStatus() !== 200)
		{
			XfAddOns_LinkEssentials_Log::log("Preview not generated, got response code: " . $response->getStatus());
			return;
		}
	
		XfAddOns_LinkEssentials_Log::log("Saving the image in: " . $this->filePath);
		$payload = $response->getBody();
		file_put_contents($this->filePath, $payload);
	}	
		
}