<?php

class XfAddOns_LinkEssentials_Util_ImageParser extends XfAddOns_LinkEssentials_Util_UrlParser
{
	
	/**
	 * In a string, look for a [URL] tag, if present, fetch an image preview
	 */
	public function generatePreviews($message, $deferredData)
	{
		$options = XenForo_Application::getOptions();
		$matches = array();
		preg_match_all('#\[URL([^]]*)\](.*)\[/URL\]#isU', $message, $matches);

		if (empty($matches[1]))
		{
			XfAddOns_LinkEssentials_Log::log("ImageParser: No urls found on the post");
			return;
		}
		
		// start parsing all the matches
		for ($i = 0; $i < count($matches[0]); $i++)
		{
			if (!empty($matches[1][$i]))
			{
				$url = $matches[1][$i];
			}
			else
			{
				$url = $matches[2][$i];
			}
			
			// we have a match
			$url = $this->normalizeUrl($url);
			XfAddOns_LinkEssentials_Log::log("ImageParser: Found the url " . $url);
			if (empty($url))
			{
				continue;
			}
			
			$this->saveImageForUrl($url, $deferredData);
		}
	}
	
	/**
	 * Save a preview for the website in the images directory 
	 * 
	 * @param string $url	The URL to save
	 */
	protected function saveImageForUrl($url, $deferredData)
	{
		$xenOptions = XenForo_Application::getOptions();
		$deferred = XenForo_Model::create('XenForo_Model_Deferred');
		$taskOptions = array(
			'url' => $url
		);
		
		$previewService = null;
		switch ($xenOptions->xfa_le_screenshot)
		{
			case 'wordpress':
				$deferred->defer('XfAddOns_LinkEssentials_Deferred_Wordpress', $taskOptions);
				break;				
			case 'page2images':
				$deferred->defer('XfAddOns_LinkEssentials_Deferred_Page2Images', $taskOptions);
				break;
			case 'wkhtmltoimage':
				$deferred->defer('XfAddOns_LinkEssentials_Deferred_WkHtmlToImage', $taskOptions);
				break;
		}
	}
	

	
	
}