<?php
/**
 * User: PiX-house.com
 * Date: 26.04.14
 * Time: 10:41
 */

class pixhousecom_lastPost_ControllerPublic_Post extends XFCP_pixhousecom_lastPost_ControllerPublic_Post
{
    public function actionPreview()
    {
        $postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);

        $ftpHelper = $this->getHelper('ForumThreadPost');
        list($post, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
        list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($post['thread_id']);

        $postModel = $this->_getPostModel();

        $post = $postModel->getPostById($post['post_id'], array(
            'join' => XenForo_Model_Thread::FETCH_USER
        ));

        if($post['post_id'] != $postId || !$postModel->canViewPost($post, $thread, $forum))
        {
            return $this->responseView('XenForo_ViewPublic_Thread_Preview', '', array('post' => false));
        }

        $viewParams = array(
            'post' => $post,
            'thread' => $thread,
            'forum' => $forum
        );

        return $this->responseView('pixhousecom_lastPost_ViewPublic_Post_Preview', 'lastPost_preview', $viewParams);
    }
}