<?php
/**
 * User: PiX-house.com
 * Date: 26.04.14
 * Time: 10:41
 */

class pixhousecom_lastPost_Model_lastPost extends XenForo_Model
{
    public function fetchLastPosts($limit = 0)
    {
        $visitor = XenForo_Visitor::getInstance();

        $postModel = $this->getModelFromCache('XenForo_Model_Post');

        $ex_forums = XenForo_Application::get('options')->lastPost_ex_forums;


        $conditions = array(
            'deleted' => false,
            'moderated' => false
        );

        $fetchOptions = array(
            'join' => XenForo_Model_Thread::FETCH_FORUM | XenForo_Model_Thread::FETCH_USER,
            'permissionCombinationId' => $visitor['permission_combination_id'],
            'readUserId' => $visitor['user_id'],
            'watchUserId' => $visitor['user_id'],
            'postCountUserId' => $visitor['user_id'],
            'order' => 'last_post_date',
            'orderDirection' => 'desc',
            'limit' => $limit,
        );


        $whereConditions = $this->getModelFromCache('XenForo_Model_Thread')->prepareThreadConditions($conditions, $fetchOptions);
        $sqlClauses = $this->getModelFromCache('XenForo_Model_Thread')->prepareThreadFetchOptions($fetchOptions);
        $limitOptions = $this->getModelFromCache('XenForo_Model_Thread')->prepareLimitFetchOptions($fetchOptions);

        if (!empty($ex_forums))
        {
            $whereConditions .= ' AND thread.node_id NOT IN (' . $this->_getDb()->quote($ex_forums) . ')';
        }

        // TODO: oha das muss besser ;)
        $sqlClauses['joinTables'] = str_replace('(user.user_id = thread.user_id)', '(user.user_id = thread.last_post_user_id)', $sqlClauses['joinTables']);

        $threads = $this->fetchAllKeyed($this->limitQueryResults('
				SELECT thread.*
					' . $sqlClauses['selectFields'] . '
				FROM xf_thread AS thread
				' . $sqlClauses['joinTables'] . '
				WHERE ' . $whereConditions . '
				' . $sqlClauses['orderClause'] . '
			', $limitOptions['limit'], $limitOptions['offset']
        ), 'thread_id');

        foreach($threads AS $threadID => &$thread)
        {
            if ($this->getModelFromCache('XenForo_Model_Thread')->canViewThreadAndContainer($thread, $thread))
            {
                $thread = $this->getModelFromCache('XenForo_Model_Thread')->prepareThread($thread, $thread);
                $thread['canInlineMod'] = false;
                $thread['showForumLink'] = true;
            }
            else
            {
                unset($threads[$threadID]);
            }
        }

        return $threads;
    }
}