<?php

class rellect_AdblockDetector_Install_Controller
{
	public static function install($existingAddOn, $addOnData, $xml = null)
	{
		if (XenForo_Application::$versionId < 1020000)
		{
			throw new XenForo_Exception('This add-on requires XenForo 1.2 or higher.', true);
		}

		if (!$existingAddOn)
		{
			// New installation
			self::runStep(1, $addOnData['version_id']);
		}
		else
		{
			// Upgrades
			if($addOnData['version_id'] > $existingAddOn['version_id'])
			{
				self::runStep($existingAddOn['version_id'] + 1, $addOnData['version_id']);
			}
		}
	}

	public static function uninstall()
	{
	}

	public static function runStep($step, $limit)
	{
		while($step <= $limit)
		{
			$fn = 'version'.$step;
			if(method_exists(get_class(), $fn))
			{
				self::$fn();
			}
			$step++;
		}
	}

	private static function version2()
	{
		// Set default permissions data
		XenForo_Application::get('db')->query("
			INSERT IGNORE INTO xf_permission_entry
				(user_group_id, user_id, permission_group_id, permission_id, permission_value, permission_value_int)
			VALUES
				#Guests
				(1, 0, 'general', 'canDismissAdBlockAlert', 'allow', 0),
				(1, 0, 'general', 'AdBlockAlertTiming', 'use_int', -1),
				
				#Registered
				(2, 0, 'general', 'canDismissAdBlockAlert', 'allow', 0),
				(2, 0, 'general', 'AdBlockAlertTiming', 'use_int', -1),
				
				#Admins
				(3, 0, 'general', 'canDismissAdBlockAlert', 'allow', 0),
				(3, 0, 'general', 'AdBlockAlertTiming', 'use_int', -1),
				(3, 0, 'general', 'bypassAdBlock', 'allow', 0),
				
				#Mods
				(4, 0, 'general', 'canDismissAdBlockAlert', 'allow', 0),
				(4, 0, 'general', 'AdBlockAlertTiming', 'use_int', -1)
		");
	}

	private static function version10()
	{
		// add controller excluded data
		$excluded = XenForo_Application::get('options')->rellect_adblock_detector_excluded_pages;
		$excluded['controllers'] = array('XenForo_ControllerPublic_Login', 'XenForo_ControllerPublic_Register');

		XenForo_Model::create('XenForo_Model_Option')->updateOptions(
			array('rellect_adblock_detector_excluded_pages' => $excluded)
		);
	}
}

?>