<?php
class rellect_AdblockDetector_Listener_Hook
{
	/**
	* Event Listener: template_hook
	*/
	public static function addJsHandler($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		if(in_array($hookName, array('page_container_js_body', 'page_container_notices')))
		{
			/**
			* Alert type, string value
			*/
			$type = XenForo_Application::get('options')->rellect_adblock_detector_alert_type;

			/**
			* If it's not a notice type, 'page_container_notices' hook isn't needed.
			*/
			if($hookName == 'page_container_notices' && $type != 'notice')
				return;

			$AdBlockHandler = XenForo_Model::create('rellect_AdblockDetector_Model_AdBlock');
			$templateParams = $template->getParams();
			$showAlert = $AdBlockHandler->showAlert(null, $templateParams); /* bool */

			/**
			* Pre v1.1.0, the js for the adblock detector was loaded only if we needed to show an alert
			* From v1.1.0 it can be loaded even if alert shouldn't be shown
			* This will be used in the future for tracking purposes
			*/
			if($showAlert)
			{
				$templateParams['showAlert'] = (int) $showAlert;
				$templateParams['canDismissAlert'] = (int) $AdBlockHandler->canDismissAlert();

				$hours = $AdBlockHandler->getAlertTimes();
				$templateParams['hours'] = (int) $hours;
				$templateParams['expiry'] = (int) $AdBlockHandler->calcExpiry($hours);

				$templateParams['whitelisted'] = (int) XenForo_Application::get('options')->rellect_adblock_detector_whitelisted;

				/**
				* This is generally needed
				*/
				if($hookName == 'page_container_js_body')
					$contents .= $template->create('rellect_adblock_detector_js', $templateParams);

				/**
				* This is needed just for the notice alert type
				*/
				if($hookName == 'page_container_notices' && $type == 'notice')
					$contents .= $template->create('rellect_adblock_detector_notice', $templateParams).$contents;
			}
		}
	}
}
?>