<?php
class rellect_AdblockDetector_Model_AdBlock extends XenForo_Model
{
	/**
	* Check if the viewing user can bypass adblock detection,
	* based on a permission
	*/
	public function canBypassDetection(array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
		if (XenForo_Permission::hasPermission($viewingUser['permissions'], 'general', 'bypassAdBlock'))
		{
			return true;
		}

		return false;
	}

	/**
	* Check if the viewing user can dismiss adblock alerts
	*/
	public function canDismissAlert(array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
		if (XenForo_Permission::hasPermission($viewingUser['permissions'], 'general', 'canDismissAdBlockAlert'))
		{
			return true;
		}

		return false;
	}

	/**
	* Get how many hours the cookie should exist,
	* based on a permission
	*/
	public function getAlertTimes(array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
		return XenForo_Permission::hasPermission($viewingUser['permissions'], 'general', 'AdBlockAlertTiming');
	}

	/**
	* Calculate how long the cookie should exist, in seconds
	*/
	public function calcExpiry($hours)
	{
		$hours = strval($hours);
		if($hours === "0")
			return 90 * 86400; // 90 days
		else if($hours == (-1))
			return 0;

		return $hours * 60 * 60; /* hours * 60minutes * 60seconds */
	}

	/**
	* Create a cookie
	*/
	public function setAlertCookie($hours)
	{
		$expiry = $this->calcExpiry($hours);
		XenForo_Helper_Cookie::setCookie('adblock_alert', intval($hours), $expiry);
	}

	/**
	* Return the cookie value
	*/
	public function getAlertCookie()
	{
		return XenForo_Helper_Cookie::getCookie('adblock_alert');
	}

	/**
	* Check if we should alert the user about Adblock
	*/
	public function showAlert(array $viewingUser = null, $templateParams)
	{
		$this->standardizeViewingUserReference($viewingUser);

		/**
		* Check if this user can bypass detection,
		* If true, stop execution
		*/
		if($this->canBypassDetection($viewingUser))
		{
			return false;
		}

		/**
		* Get excluded pages
		*/
		$excluded = XenForo_Application::get('options')->rellect_adblock_detector_excluded_pages;

			// Check if this is excluded content template
			if(!empty($excluded['templates']) AND in_array($templateParams['contentTemplate'], $excluded['templates']))
			{
				return false;
			}

			// Check if this is excluded controller
			if(!empty($excluded['controllers']) && isset($templateParams['controllerName'], $templateParams['controllerAction']))
			{
				foreach($excluded['controllers'] as $controller)
				{
					$c = (array) explode('::', strtolower($controller));

					if (strtolower($templateParams['controllerName']) == $c[0])
					{
						if(!empty($c[1]))
						{
							if (strtolower($templateParams['controllerAction']) == $c[1])
								return false;
						}
						else
							return false;
					}
				}
			}

			// Check if this is a node
			if(!empty($excluded['node_ids']) AND !empty($templateParams['bodyClasses']))
			{
				$node_ids = explode(' ', str_replace('node', '', $templateParams['bodyClasses']));

				// if not empty, this is a node
				if(!empty($node_ids))
				{
					// Exclude the current node
					if($excluded['node_ids'] == $node_ids)
						return false;

					// Exclude current node's childs
					if(!empty($excluded['node_child']))
					{
						foreach($excluded['node_ids'] as $nodeid)
						{
							if(in_array($nodeid, $node_ids))
								return false;
						}
					}
				}
			}


		/**
		* $hours contains the current amount of hours that set in the permission
		* $alertCookie contains the amount of hours at the moment it was created
		*/
		$hours = $this->getAlertTimes($viewingUser);
		$alertCookie = $this->getAlertCookie();

		/**
		* A cookie stores for how long not to show an alert.
		* If the cookie still exist, (means the user already saw an alert),
		* We check two things:
		* 1. If the cookie value is 0, means the user shouldn't see the alert again.
		* 2. Second, we check if the permissions is changed (based on the cookie value). If yes, we show the alert again.
		*
		* As long $alertCookie exist, and it equals to $hours, we don't show the alert
		*/
		if(($alertCookie OR $alertCookie === "0") AND intval($alertCookie) === intval($hours))
		{
			// Don't show alert at the moment
			return false;
		}

		/**
		* if $hours equal to (-1), means there is no time limit and we always show the alert
		*/
		if($hours == (-1))
		{
			return true;
		}

		/**
		* If user can't dismiss the alert, automatically we creates a cookie to store for how long not to show the alert.
		* In case he can dismiss, this will be covered by js
		*/
		if(!$this->canDismissAlert($viewingUser))
			$this->setAlertCookie($hours);

		return true;
	}
}
?>