<?php
class rellect_AdblockDetector_Option_ExcludePages
{
	/**
	 * Renders the option row.
	 *
	 * @param XenForo_View $view View object
	 * @param string $fieldPrefix Prefix for the HTML form field name
	 * @param array $preparedOption Prepared option info
	 * @param boolean $canEdit True if an "edit" link should appear
	 *
	 * @return XenForo_Template_Abstract Template object
	 */
	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$value = isset($preparedOption['option_value']['page_criteria']) ? $preparedOption['option_value']['page_criteria'] : array();

		$editLink = $view->createTemplateObject('option_list_option_editlink', array(
			'preparedOption' => $preparedOption,
			'canEditOptionDefinition' => $canEdit
		));

		return $view->createTemplateObject('option_rellect_adblock_detector_excluded_pages', array(
			'fieldPrefix' => $fieldPrefix,
			'listedFieldName' => $fieldPrefix . '_listed[]',
			'preparedOption' => $preparedOption,
			'editLink' => $editLink,
			'nodes' => XenForo_Model::create('XenForo_Model_Node')->getAllNodes()
		));
	}

	/**
	 * @param array $values current input
	 * @param XenForo_DataWriter $dw Calling DW
	 * @param string $fieldName Name of field/option
	 *
	 * @return true
	 */
	public static function verifyOption(array &$values, XenForo_DataWriter $dw, $fieldName)
	{
		if(!empty($values['controllers']))
		{
			$values['controllers'] = array_map('trim', $values['controllers']); // clean up white spaces
			$values['controllers'] = array_filter($values['controllers']); // remove empty values
			$values['controllers'] = array_unique($values['controllers']); // remove duplicated values
		}
		else
			$values['controllers'] = array();

		if(!empty($values['templates']))
		{
			$values['templates'] = array_map('trim', $values['templates']); // clean up white spaces
			$values['templates'] = array_filter($values['templates']); // remove empty values
			$values['templates'] = array_unique($values['templates']); // remove duplicated values
		}
		else
			$values['templates'] = array();

		if(empty($values['node_ids']))
			$values['node_ids'] = array();

		return true;
	}
}