<?php

/*
 *	robodn Common Library
 *  Base.php 0.3
 *  (this library added like this so I don't have to worry about backwards compatability)
 *
 *  This class is a base for all others in this library. Adds basic helpers.
 *  Also adds the missing lcfirst from PHP 5.2 (really PHP, really?)
 */

if (!class_exists('robodn_Common_Base_Version03'))
{
	abstract class robodn_Common_Base_Version03
	{
		/**
		* Database object
		*
		* @var Zend_Db_Adapter_Abstract
		*/
		protected $_db = null;

		/**
		 * Standard approach to caching model objects for the lifetime of the object.
		 *
		 * @var array
		 */
		protected $_modelCache = array();

		/**
		 * Gets the specified model object from the cache. If it does not exist,
		 * it will be instantiated.
		 *
		 * @param string $class Name of the class to load
		 *
		 * @return XenForo_Model
		 */
		public function getModelFromCache($class)
		{
			if ( ! isset($this->_modelCache[$class]))
			{
				$this->_modelCache[$class] = XenForo_Model::create($class);
			}

			return $this->_modelCache[$class];
		}

		/**
		* Helper method to get the database object.
		*
		* @return Zend_Db_Adapter_Abstract
		*/
		protected function _getDb()
		{
			if ($this->_db === null)
			{
				$this->_db = XenForo_Application::getDb();
			}

			return $this->_db;
		}
	}
}

if(function_exists('lcfirst') === false)
{
    /**
     * Make a string's first character lowercase
     *
     * @param string $str
     * @return string the resulting string.
     */
    function lcfirst($str)
    {
        return strtolower(substr($str, 0, 1)) . substr($str, 1);
    }
}

eval('class robodn_' . basename(dirname(dirname(__FILE__))) . '_Common_Base extends robodn_Common_Base_Version03 {}');