<?php

class robodn_DonationManager_ControllerHelper_Sidebar extends XenForo_ControllerHelper_Abstract
{
	public function getTopDonations($goalId = null)
	{
		if (!XenForo_Visitor::getInstance()->hasPermission('donation', 'viewDonations'))
		{
			return array();
		}

		$conditions = array();
		if ($goalId)
		{
			$conditions['goal'] = $goalId;
		}

		return $this->_controller->getModelFromCache('robodn_DonationManager_Model_Donation')->getDonations($conditions, array(
			'limit' => XenForo_Application::getOptions()->sidebarTopDonationsAmount,
			'order' => 'amount',
			'direction' => 'desc',
			'join' => robodn_DonationManager_Model_Donation::FETCH_USER,
		));
	}

	// TODO: log goal_id with donors?
	public function getTopDonors()
	{
		if (!XenForo_Visitor::getInstance()->hasPermission('donation', 'viewDonors'))
		{
			return array();
		}

		return $this->_controller->getModelFromCache('robodn_DonationManager_Model_Donor')->getDonors(array(), array(
			'limit' => XenForo_Application::getOptions()->sidebarTopDonorsAmount,
			'order' => 'amount',
			'direction' => 'desc',
			'join' => robodn_DonationManager_Model_Donor::FETCH_USER,
		));
	}
}