<?php

class robodn_DonationManager_ControllerPublic_Donation extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		if (!XenForo_Visitor::getInstance()->hasPermission('donation', 'viewDonations'))
		{
			return $this->responseNoPermission();
		}

		$goal = false;
		if ($goalId = $this->_input->filterSingle('goal_id', XenForo_Input::UINT))
		{
			$goal = $this->getModelFromCache('robodn_DonationManager_Model_Goal')->getGoalById($goalId);
		}

		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		$perPage = XenForo_Application::getOptions()->donationsPerPage;

		$order = $this->_input->filterSingle('order', XenForo_Input::STRING, array('default' => 'donation_date'));
		$orderDirection = $this->_input->filterSingle('direction', XenForo_Input::STRING, array('default' => 'desc'));

		$fetchOptions = array(
			'page' => $page,
			'perPage' => $perPage,
			'order' => $order,
			'direction' => $orderDirection,
			'join' => robodn_DonationManager_Model_Donation::FETCH_GOAL
		);

		$conditions = array();
		$link = 'donations';
		$linkData = array();
		if ($goal)
		{
			$conditions['goal'] = $goalId;
			$link = 'goals/donations';
			$linkData = $goal;
		}

		$this->canonicalizeRequestUrl(
			XenForo_Link::buildPublicLink($link, $linkData, array('page' => $page))
		);

		$donationModel = $this->_getDonationModel();

		$totalDonations = $donationModel->countDonations($conditions);
		$this->canonicalizePageNumber($page, $perPage, $totalDonations, $link, $linkData);
		$donations = $donationModel->getDonations($conditions, $fetchOptions);

		$sidebarHelper = $this->getHelper('robodn_DonationManager_ControllerHelper_Sidebar');
		$viewParams = array(
			'donations' => $donations,

			'goal' => $goal,

			'page' => $page,
			'perPage' => $perPage,
			'totalDonations' => $totalDonations,
			'donationStart' => ($page - 1) * $perPage + 1,
			'donationEnd' => ($page - 1) * $perPage + count($donations),

			'order' => $order,
			'orderDirection' => $orderDirection,

			'topDonors' => $sidebarHelper->getTopDonors(),
			'topDonations' => $sidebarHelper->getTopDonations($goal ? $goalId : null),
		);

		return $this->responseView('robodn_DonationManager_ViewPublic_Donation_List', 'robodn_donation_list', $viewParams);
	}

	protected function _getDonationModel()
	{
		return $this->getModelFromCache('robodn_DonationManager_Model_Donation');
	}
}