<?php

class robodn_DonationManager_ControllerPublic_Donor extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		if (!XenForo_Visitor::getInstance()->hasPermission('donation', 'viewDonors'))
		{
			return $this->responseNoPermission();
		}

		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		$perPage = XenForo_Application::getOptions()->donorsPerPage;

		$order = $this->_input->filterSingle('order', XenForo_Input::STRING, array('default' => 'amount'));
		$orderDirection = $this->_input->filterSingle('direction', XenForo_Input::STRING, array('default' => 'desc'));

		$fetchOptions = array(
			'page' => $page,
			'perPage' => $perPage,
			'order' => $order,
			'direction' => $orderDirection,
			'join' => robodn_DonationManager_Model_Donor::FETCH_USER,
		);

		$this->canonicalizeRequestUrl(
			XenForo_Link::buildPublicLink('donors', array(), array('page' => $page))
		);

		$donorModel = $this->getModelFromCache('robodn_DonationManager_Model_Donor');

		$totalDonors = $donorModel->countDonors();

		$this->canonicalizePageNumber($page, $perPage, $totalDonors, 'donors');

		$donors = $donorModel->getDonors(array(), $fetchOptions);

		$sidebarHelper = $this->getHelper('robodn_DonationManager_ControllerHelper_Sidebar');
		$viewParams = array(
			'donors' => $donorModel->prepareDonors($donors),

			'page' => $page,
			'perPage' => $perPage,
			'totalDonors' => $totalDonors,
			'donorStart' => ($page - 1) * $perPage + 1,
			'donorEnd' => ($page - 1) * $perPage + count($donors),

			'order' => $order,
			'orderDirection' => $orderDirection,

			'topDonors' => $sidebarHelper->getTopDonors(),
			'topDonations' => $sidebarHelper->getTopDonations(),
		);

		return $this->responseView('robodn_DonationManager_ViewPublic_Donor_List', 'robodn_donor_list', $viewParams);
	}
}