<?php

class robodn_DonationManager_ControllerPublic_Goal extends XenForo_ControllerPublic_Abstract
{
	protected function _preDispatch($action)
	{
		if (!XenForo_Visitor::getInstance()->hasPermission('donation', 'viewIndex'))
		{
			throw $this->responseException($this->responseNoPermission());
		}
	}
	
	public function actionIndex()
	{
		if (!$goalId = $this->_input->filterSingle('goal_id', XenForo_Input::UINT))
		{
			return $this->responseNoPermission();
		}

		if (!$goal = $this->_getGoalModel()->getGoalById($goalId, array('join' => robodn_DonationManager_Model_Goal::FETCH_LOG_COUNT)))
		{
			return $this->responseNoPermission();
		}

		$donations = array();
		if (XenForo_Visitor::getInstance()->hasPermission('donation', 'viewDonations'))
		{
			$donations = $this->_getDonationModel()->getDonations(array('goal' => $goalId), array('limit' => 7));
		}

		// TODO: this is copied somewhere else, use a helper or something
		$options = XenForo_Application::getOptions();
		$amounts = $options->donationAmounts;
		$totalAmount = 0;
		if (!empty($amounts))
		{
			$amounts = explode(',', $amounts);
			foreach ($amounts as $k => $amount)
			{
				$amount = (int) $amount;
				if (empty($amount) || $amount < (int) $options->minimumDonationAmount)
					unset($amounts[$k]);
				else
				{
					$amounts[$k] = $amount;
					$totalAmount += $amount;
				}
			}
		}

		$averageAmount = round($totalAmount / count($amounts) / 2, -1) - 0.05;

		$sidebarHelper = $this->getHelper('robodn_DonationManager_ControllerHelper_Sidebar');
		$viewParams = array(
			'goal' => $this->_getGoalModel()->prepareGoal($goal),
			'goals' => $this->_getGoalModel()->getGoals(array('archived' => 0)),

			'topDonors' => $sidebarHelper->getTopDonors(),
			'topDonations' => $sidebarHelper->getTopDonations($goalId),

			'recentDonations' => $donations,

			'amounts' => $amounts,
			'allowOpenAmount' => $options->allowOpenDonationAmount || empty($amounts),
			'averageAmount' => $averageAmount,

			'donating' => $this->_input->filterSingle('donating', XenForo_Input::UINT),
			'canDonate' => XenForo_Visitor::getInstance()->hasPermission('donation', 'donate'),

			'thanks' => $this->_input->filterSingle('thanks', XenForo_Input::UINT),
		);

		if ($viewParams['donating'] && !$options->acceptingDonations)
		{
			$error = $options->notAcceptingDonationsMessage;
			if (empty($error))
			{
				$error = new XenForo_Phrase('robodn_donations_arent_currently_being_accepted');
			}

			return $this->responseError(nl2br($error));
		}

		$containerParams = array(
			'showDonationsOffNotice' => !$options->acceptingDonations
		);

		return $this->responseView('robodn_DonationManager_ViewPublic_Goal_View', 'robodn_goal', $viewParams, $containerParams);
	}

	public function actionHistory()
	{
		if (!$goalId = $this->_input->filterSingle('goal_id', XenForo_Input::UINT))
		{
			return $this->responseNoPermission();
		}

		if (!$goal = $this->_getGoalModel()->getGoalById($goalId, array('join' => robodn_DonationManager_Model_Goal::FETCH_LOG_COUNT)))
		{
			return $this->responseNoPermission();
		}

		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		$perPage = 12;
		$fetchOptions = array(
			'page' => $page,
			'perPage' => $perPage
		);
		$conditions = array(
			'goal' => $goalId
		);

		$this->canonicalizeRequestUrl(
			XenForo_Link::buildPublicLink('goals/history', $goal, array('page' => $page))
		);

		$totalLogs = $this->_getGoalModel()->countGoalLogs($conditions);
		$this->canonicalizePageNumber($page, $perPage, $totalLogs, 'goals/history', $goal);
		$logs = $this->_getGoalModel()->getGoalLogs($conditions, $fetchOptions);

		// TODO: this should be in a view
		// This is just to not show the year when everything being shown is on the current year
		$year = date('Y');
		$dateFormat = 'M d';
		foreach ($logs AS $log)
		{
			if (date('Y', $log['start_date']) != $year OR date('Y', $log['end_date']) != $year)
			{
				$dateFormat .= ', Y';
				break;
			}
		}

		$sidebarHelper = $this->getHelper('robodn_DonationManager_ControllerHelper_Sidebar');
		$viewParams = array(
			'logs' => $this->_getGoalModel()->prepareGoals($logs),

			'goal' => $goal,

			'page' => $page,
			'perPage' => $perPage,
			'totalLogs' => $totalLogs,
			'donationStart' => ($page - 1) * $perPage + 1,
			'donationEnd' => ($page - 1) * $perPage + count($logs),

			'dateFormat' => $dateFormat,

			'topDonors' => $sidebarHelper->getTopDonors(),
			'topDonations' => $sidebarHelper->getTopDonations($goalId),
		);

		return $this->responseView('robodn_DonationManager_ViewPublic_Goal_History', 'robodn_goal_history', $viewParams);
	}

	public function actionDonations()
	{
		return $this->responseReroute('robodn_DonationManager_ControllerPublic_Donation', 'index');
	}

	public function actionDonate()
	{
		$this->_request->setParam('donating', 1);
		return $this->responseReroute(__CLASS__, 'index');
	}

	protected function _checkCsrf($action)
	{
		if (strtolower($action) == 'index' && $this->_input->filterSingle('thanks', XenForo_Input::UINT))
		{
			// may be coming from external payment gateway
			return;
		}

		parent::_checkCsrf($action);
	}

	protected function _getGoalModel()
	{
		return $this->getModelFromCache('robodn_DonationManager_Model_Goal');
	}

	protected function _getDonationModel()
	{
		return $this->getModelFromCache('robodn_DonationManager_Model_Donation');
	}
}