<?php

class robodn_DonationManager_DataWriter_Goal extends XenForo_DataWriter
{
	protected function _getFields()
	{
		return array(
			'robodn_goal' => array(
				'goal_id' => array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'title' => array('type' => self::TYPE_STRING, 'required' => true),
				'description' => array('type' => self::TYPE_STRING, 'required' => true),
				'donated' => array('type' => self::TYPE_FLOAT, 'default' => 0),
				'goal' => array('type' => self::TYPE_FLOAT, 'required' => true, 'verification' => array('$this', '_verifyGoal')),
				'goal_reached' => array('type' => self::TYPE_STRING, 'default' => '', 'allowedValues' => array('', 'restart', 'archive')),
				'start_date' => array('type' => self::TYPE_UINT, 'default' => XenForo_Application::$time),
				'end_date' => array('type' => self::TYPE_UINT, 'default' => 0),
				'recurring' => array('type' => self::TYPE_BOOLEAN, 'default' => 0),
				'archived' => array('type' => self::TYPE_BOOLEAN, 'default' => 0),
				'feature' => array('type' => self::TYPE_BOOLEAN, 'default' => 0),
				'display_order' => array('type' => self::TYPE_UINT, 'default' => 0)
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('robodn_goal' => $this->_getGoalModel()->getGoalById($id));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'goal_id = ' . $this->_db->quote($this->getExisting('goal_id'));
	}

	public function addDonation($amount, $donationDate)
	{
		if ($donationDate >= $this->get('start_date') AND $donationDate <= $this->get('end_date'))
		{
			$this->set('donated', max(0, $this->get('donated') + $amount));
			return true;
		}

		// TODO: move this query to a model?
		$logs = $this->_db->fetchAll('
			SELECT *
			FROM robodn_goal_log
			WHERE goal_id = ?
		', $this->get('goal_id'));

		$validLog = false;
		foreach ($logs AS $log)
		{
			if ($donationDate >= $log['start_date'] AND $donationDate <= $log['end_date'])
			{
				$validLog = $log;
				break;
			}
		}

		if ($validLog)
		{
			$this->_db->query('
				UPDATE robodn_goal_log
				SET donated = ?
				WHERE goal_log_id = ?
			', array(max(0, $log['donated'] + $amount), $log['goal_log_id']));
			return false;
		}

		$this->error('specified_goal_wasnt_active_at_the_set_time');
		return false;
	}

	protected function _postSave()
	{
		if ($this->get('goal_reached') != '' AND $this->get('donated') >= $this->get('goal'))
		{
			if ($this->get('goal_reached') == 'restart')
			{
				$this->_getGoalModel()->logAndRestartGoal($this->get('goal_id'));
			}
			else if ($this->get('goal_reached') == 'archive' AND !$this->get('archived'))
			{
				$this->_getGoalModel()->archiveGoal($this->get('goal_id'));
			}
		}
	}

	protected function _verifyGoal($goal)
	{
		$goal = (int) $goal;
		if (!$goal)
		{
			$this->error('goal_can_not_be_zero', 'goal');
			return false;
		}

		return true;
	}

	protected function _getGoalModel()
	{
		return $this->getModelFromCache('robodn_DonationManager_Model_Goal');
	}
}